/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.messages.endpoints;

import java.util.Collection;
import java.util.Locale;
import org.smarti18n.api.MessagesApi;
import org.smarti18n.exceptions.MessageExistException;
import org.smarti18n.exceptions.MessageUnknownException;
import org.smarti18n.exceptions.ProjectUnknownException;
import org.smarti18n.exceptions.UserRightsException;
import org.smarti18n.exceptions.UserUnknownException;
import org.smarti18n.messages.security.SecurityUtils;
import org.smarti18n.messages.service.MessagesService;
import org.smarti18n.models.Message;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MessagesEndpoint
implements MessagesApi {
    private final MessagesService messagesService;

    public MessagesEndpoint(MessagesService messagesService) {
        this.messagesService = messagesService;
    }

    @GetMapping(value={"/api/1/messages/findAll"})
    public Collection<Message> findAll(@RequestParam(value="projectId") String projectId) throws ProjectUnknownException, UserUnknownException, UserRightsException {
        return this.messagesService.findAll(SecurityUtils.getUserId(), projectId);
    }

    @GetMapping(value={"/api/1/messages/findOne"})
    public Message findOne(@RequestParam(value="projectId") String projectId, @RequestParam(value="key") String key) throws ProjectUnknownException, UserUnknownException, UserRightsException {
        return this.messagesService.findOne(SecurityUtils.getUserId(), projectId, key);
    }

    @GetMapping(value={"/api/1/messages/insert"})
    public Message insert(@RequestParam(value="projectId") String projectId, @RequestParam(value="key") String key) throws UserRightsException, MessageExistException, UserUnknownException, ProjectUnknownException {
        return this.messagesService.insert(SecurityUtils.getUserId(), projectId, key);
    }

    @GetMapping(value={"/api/1/messages/update"})
    public Message update(@RequestParam(value="projectId") String projectId, @RequestParam(value="key") String key, @RequestParam(value="locale") Locale locale, @RequestParam(value="translation") String translation) throws ProjectUnknownException, UserUnknownException, UserRightsException {
        return this.messagesService.update(SecurityUtils.getUserId(), projectId, key, locale, translation);
    }

    @PostMapping(value={"/api/1/messages/update"})
    public Message update(@RequestParam(value="projectId") String projectId, @RequestBody Message message) throws UserUnknownException, MessageUnknownException, UserRightsException, ProjectUnknownException {
        return this.messagesService.update(SecurityUtils.getUserId(), projectId, message);
    }

    @GetMapping(value={"/api/1/messages/copy"})
    public Message copy(@RequestParam(value="projectId") String projectId, @RequestParam(value="sourceKey") String sourceKey, @RequestParam(value="targetKey") String targetKey) throws UserRightsException, MessageExistException, MessageUnknownException, UserUnknownException, ProjectUnknownException {
        return this.messagesService.copy(SecurityUtils.getUserId(), projectId, sourceKey, targetKey);
    }

    @GetMapping(value={"/api/1/messages/remove"})
    public void remove(@RequestParam(value="projectId") String projectId, @RequestParam(value="key") String key) throws ProjectUnknownException, UserUnknownException, UserRightsException {
        this.messagesService.remove(SecurityUtils.getUserId(), projectId, key);
    }
}

