/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.messages.endpoints;

import java.util.List;
import org.smarti18n.api.ProjectsApi;
import org.smarti18n.exceptions.ProjectExistException;
import org.smarti18n.exceptions.ProjectUnknownException;
import org.smarti18n.exceptions.UserRightsException;
import org.smarti18n.exceptions.UserUnknownException;
import org.smarti18n.messages.security.SecurityUtils;
import org.smarti18n.messages.service.ProjectsService;
import org.smarti18n.models.Project;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProjectsEndpoint
implements ProjectsApi {
    private final ProjectsService projectsService;

    public ProjectsEndpoint(ProjectsService projectsService) {
        this.projectsService = projectsService;
    }

    @GetMapping(value={"/api/1/projects/findAll"})
    public List<Project> findAll() throws UserUnknownException {
        return this.projectsService.findAll(SecurityUtils.getUserId());
    }

    @GetMapping(value={"/api/1/projects/findOne"})
    public Project findOne(@RequestParam(value="projectId") String projectId) throws UserUnknownException, UserRightsException {
        return this.projectsService.findOne(SecurityUtils.getUserId(), projectId);
    }

    @GetMapping(value={"/api/1/projects/insert"})
    public Project insert(@RequestParam(value="projectId") String projectId, @RequestParam(value="parentProjectId", required=false) String parentProjectId) throws UserUnknownException, ProjectExistException {
        return this.projectsService.insert(SecurityUtils.getUserId(), projectId, parentProjectId);
    }

    @PostMapping(value={"/api/1/projects/update"})
    public Project update(@RequestBody Project project) throws ProjectUnknownException, UserUnknownException, UserRightsException {
        return this.projectsService.update(SecurityUtils.getUserId(), project);
    }

    @GetMapping(value={"/api/1/projects/remove"})
    public void remove(@RequestParam(value="projectId") String projectId) throws ProjectUnknownException, UserUnknownException, UserRightsException {
        this.projectsService.remove(SecurityUtils.getUserId(), projectId);
    }
}

