/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.messages.endpoints;

import java.util.List;
import org.smarti18n.api.UserApi;
import org.smarti18n.exceptions.UserExistException;
import org.smarti18n.exceptions.UserUnknownException;
import org.smarti18n.messages.service.UserService;
import org.smarti18n.models.User;
import org.smarti18n.models.UserSimplified;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserEndpoint
implements UserApi {
    private final UserService userService;

    public UserEndpoint(UserService userService) {
        this.userService = userService;
    }

    @GetMapping(value={"/api/1/users/findAll"})
    public List<User> findAll() {
        return this.userService.findAll();
    }

    @GetMapping(value={"/api/1/users/findOne"})
    public User findOne(@RequestParam(value="mail") String mail) throws UserUnknownException {
        return this.userService.findOne(mail);
    }

    @GetMapping(value={"/api/1/users/findOneSimplified"})
    public UserSimplified findOneSimplified(@RequestParam(value="mail") String mail) {
        return this.userService.findOneSimplified(mail);
    }

    @GetMapping(value={"/api/1/users/register"})
    public User register(@RequestParam(value="mail") String mail, @RequestParam(value="password") String password) throws UserExistException {
        return this.userService.register(mail, password);
    }

    @PostMapping(value={"/api/1/users/update"})
    public User update(@RequestBody User user) throws UserUnknownException {
        return this.userService.update(user);
    }
}

