/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.messages.entities;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.smarti18n.messages.entities.UserEntity;
import org.smarti18n.models.Project;
import org.smarti18n.models.User;
import org.smarti18n.models.UserRole;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="projects")
public class ProjectEntity
implements Project {
    @Id
    private String id;
    private String name;
    private String description;
    private String secret;
    private Set<Locale> locales = new HashSet();
    @DBRef
    private Set<UserEntity> owners = new HashSet();
    @DBRef
    private ProjectEntity parentProject;

    ProjectEntity() {
    }

    public ProjectEntity(String id, String secret, UserEntity user) {
        this.id = id;
        this.secret = secret;
        this.owners.add(user);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<Locale> getLocales() {
        return this.locales;
    }

    public void setLocales(Set<Locale> locales) {
        this.locales = locales;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Set<User> getOwners() {
        return new HashSet<User>(this.owners);
    }

    public void setOwners(Set<User> owners) {
        this.owners = owners.stream().map(UserEntity::new).collect(Collectors.toSet());
    }

    public void addOwner(UserEntity user) {
        this.owners.add(user);
    }

    public boolean hasOwner(UserEntity user) {
        return user.getRole() == UserRole.SUPERUSER || this.owners.contains(user);
    }

    public ProjectEntity getParentProject() {
        return this.parentProject;
    }

    public void setParentProject(ProjectEntity parentProject) {
        this.parentProject = parentProject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectEntity)) {
            return false;
        }
        ProjectEntity that = (ProjectEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }
}

