/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.messages.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;

public class CustomBasicAuthenticationEntryPoint
extends BasicAuthenticationEntryPoint {
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        response.setStatus(401);
        response.addHeader("WWW-Authenticate", "Basic realm=" + this.getRealmName() + "");
        response.getWriter().println("HTTP Status 401 : " + authException.getMessage());
    }

    public void afterPropertiesSet() throws Exception {
        this.setRealmName("SMARTI18N_MESSAGES");
        super.afterPropertiesSet();
    }
}

