/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.messages.security;

import java.util.HashMap;
import org.smarti18n.messages.security.CustomBasicAuthenticationEntryPoint;
import org.smarti18n.messages.security.UserOrProjectPrincipalService;
import org.smarti18n.models.UserRole;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.crypto.password.StandardPasswordEncoder;
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableWebSecurity
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    static final String REALM = "SMARTI18N_MESSAGES";
    private static final String ROLE_SUPERUSER = UserRole.SUPERUSER.name();
    private static final String ROLE_USER = UserRole.USER.name();
    @Autowired
    private UserOrProjectPrincipalService userOrProjectPrincipalService;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/api/1/messages/findForSpringMessageSource"})).hasAuthority("PROJECT").antMatchers(new String[]{"/api/1/messages/findAll", "/api/1/messages/findOne", "/api/1/messages/insert", "/api/1/messages/update", "/api/1/messages/copy", "/api/1/messages/remove", "/api/1/projects/findAll", "/api/1/projects/findOne", "/api/1/projects/insert", "/api/1/projects/update", "/api/1/projects/remove", "/api/1/users/findOne", "/api/1/users/update"})).hasAnyAuthority(new String[]{ROLE_USER, ROLE_SUPERUSER}).antMatchers(new String[]{"/api/1/users/findAll", "/api/1/users/register"})).hasAuthority(ROLE_SUPERUSER).antMatchers(new String[]{"/api/1/users/findOneSimplified", "/api/1/messages/findForAngularMessageSource"})).permitAll().anyRequest()).denyAll().and()).httpBasic().realmName(REALM).authenticationEntryPoint((AuthenticationEntryPoint)new CustomBasicAuthenticationEntryPoint()).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"});
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.authenticationProvider());
    }

    @Bean
    public DaoAuthenticationProvider authenticationProvider() {
        DaoAuthenticationProvider authProvider = new DaoAuthenticationProvider();
        authProvider.setUserDetailsService((UserDetailsService)this.userOrProjectPrincipalService);
        authProvider.setPasswordEncoder(this.encoder());
        return authProvider;
    }

    @Bean
    public PasswordEncoder encoder() {
        String idForEncode = "bcrypt";
        HashMap<String, Object> encoders = new HashMap<String, Object>();
        encoders.put("bcrypt", new BCryptPasswordEncoder());
        encoders.put(null, NoOpPasswordEncoder.getInstance());
        encoders.put("noop", NoOpPasswordEncoder.getInstance());
        encoders.put("pbkdf2", new Pbkdf2PasswordEncoder());
        encoders.put("scrypt", new SCryptPasswordEncoder());
        encoders.put("sha256", new StandardPasswordEncoder());
        return new DelegatingPasswordEncoder("bcrypt", encoders);
    }

    @Bean
    public WebMvcConfigurer corsConfigurer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

