/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.messages.security;

import java.util.Optional;
import org.smarti18n.messages.entities.UserEntity;
import org.smarti18n.messages.repositories.UserRepository;
import org.smarti18n.messages.security.UserPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class UserPrincipalService
implements UserDetailsService {
    private final UserRepository userRepository;

    public UserPrincipalService(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Optional byMail = this.userRepository.findByMail(username);
        if (byMail.isPresent()) {
            return new UserPrincipal((UserEntity)byMail.get());
        }
        throw new UsernameNotFoundException(username);
    }
}

