/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.messages.service;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smarti18n.messages.entities.ProjectEntity;
import org.smarti18n.messages.entities.UserEntity;
import org.smarti18n.messages.repositories.MessageRepository;
import org.smarti18n.messages.repositories.ProjectRepository;
import org.smarti18n.messages.repositories.UserRepository;
import org.smarti18n.messages.service.SmartKeyGenerator;
import org.smarti18n.models.UserCredentials;
import org.smarti18n.models.UserRole;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class ApplicationInitializer
implements ApplicationListener<ApplicationReadyEvent> {
    private static final String DEFAULT_PROJECT_ID = "default";
    private static final String DEFAULT_USER_MAIL = "default@smarti18n.com";
    private final Logger logger = LoggerFactory.getLogger(ApplicationInitializer.class);
    private final SmartKeyGenerator keyGenerator;
    private final UserRepository userRepository;
    private final ProjectRepository projectRepository;
    private final MessageRepository messageRepository;
    private final PasswordEncoder passwordEncoder;
    private final Environment environment;

    public ApplicationInitializer(SmartKeyGenerator keyGenerator, UserRepository userRepository, ProjectRepository projectRepository, MessageRepository messageRepository, PasswordEncoder passwordEncoder, Environment environment) {
        this.keyGenerator = keyGenerator;
        this.userRepository = userRepository;
        this.projectRepository = projectRepository;
        this.messageRepository = messageRepository;
        this.passwordEncoder = passwordEncoder;
        this.environment = environment;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.logger.info("#######################################################################");
        this.logger.info("Initializing Application");
        this.projectRepository.findAll().forEach(projectEntity -> {
            projectEntity.setId(projectEntity.getId().trim().toLowerCase());
            this.projectRepository.save(projectEntity);
        });
        this.messageRepository.findAll().forEach(messageEntity -> {
            messageEntity.setKey(messageEntity.getKey().trim().toLowerCase());
            this.messageRepository.save(messageEntity);
        });
        if (!this.userRepository.findByMail(DEFAULT_USER_MAIL).isPresent()) {
            String password = this.keyGenerator.generateKey();
            this.logger.info("Create Default User [default@smarti18n.com] with Password [" + password + "]");
            String encodedPassword = this.passwordEncoder.encode((CharSequence)password);
            UserEntity userEntity = new UserEntity(DEFAULT_USER_MAIL, encodedPassword, UserRole.SUPERUSER);
            userEntity.setVorname("Default");
            userEntity.setNachname("Default");
            userEntity.setCompany("Default");
            this.userRepository.insert((Object)userEntity);
        }
        UserEntity defaultUser = (UserEntity)this.userRepository.findByMail(DEFAULT_USER_MAIL).orElseThrow(() -> new IllegalStateException("Default User [default@smarti18n.com] doesn't exist"));
        if (!this.projectRepository.findById((Object)DEFAULT_PROJECT_ID).isPresent()) {
            String secret = this.keyGenerator.generateKey();
            this.logger.info("create default project [default] with secret [" + secret + "]");
            ProjectEntity projectEntity2 = new ProjectEntity(DEFAULT_PROJECT_ID, secret, defaultUser);
            projectEntity2.setName("Default Project");
            projectEntity2.setDescription("Default Project");
            this.projectRepository.insert((Object)projectEntity2);
        }
        this.projectRepository.findAll().forEach(project -> {
            if (project.getOwners().isEmpty()) {
                project.addOwner(defaultUser);
                this.projectRepository.save(project);
            }
        });
        this.userRepository.findAll().stream().filter(user -> user.getRole() == null).forEach(user -> {
            user.setRole(UserRole.SUPERUSER);
            this.userRepository.save(user);
        });
        if (Arrays.asList(this.environment.getActiveProfiles()).contains("test")) {
            this.logger.info("");
            this.logger.info("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            this.logger.info("!!!!!!!!!!!!!!!!!!!!!! TEST INITIALIZATION !!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            this.logger.info("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            this.logger.info("");
            String username = UserCredentials.TEST.getUsername();
            String password = UserCredentials.TEST.getPassword();
            String encodedPassword = this.passwordEncoder.encode((CharSequence)password);
            UserEntity userEntity = new UserEntity(username, encodedPassword, UserRole.SUPERUSER);
            userEntity.setVorname("TEST");
            userEntity.setNachname("TEST");
            userEntity.setCompany("TEST");
            this.userRepository.insert((Object)userEntity);
            ProjectEntity projectEntity3 = new ProjectEntity("test", "test", defaultUser);
            projectEntity3.setName("Test Project");
            projectEntity3.setDescription("Test Project");
            this.projectRepository.insert((Object)projectEntity3);
        }
        this.logger.info("Initializing Application finished");
        this.logger.info("#######################################################################");
    }
}

