/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.messages.service;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smarti18n.exceptions.ProjectUnknownException;
import org.smarti18n.exceptions.UserRightsException;
import org.smarti18n.exceptions.UserUnknownException;
import org.smarti18n.messages.entities.ProjectEntity;
import org.smarti18n.messages.entities.UserEntity;
import org.smarti18n.messages.repositories.ProjectRepository;
import org.smarti18n.messages.repositories.UserRepository;
import org.smarti18n.messages.service.EntityLoader;
import org.smarti18n.messages.service.IdentifierUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class EntityLoaderImpl
implements EntityLoader {
    private final UserRepository userRepository;
    private final ProjectRepository projectRepository;
    private final Logger logger = LoggerFactory.getLogger(EntityLoaderImpl.class);

    public EntityLoaderImpl(UserRepository userRepository, ProjectRepository projectRepository) {
        this.userRepository = userRepository;
        this.projectRepository = projectRepository;
    }

    public UserEntity findUser(String username) throws UserUnknownException {
        Optional user = this.userRepository.findByMail(IdentifierUtils.clean((String)username));
        if (user.isPresent()) {
            return (UserEntity)user.get();
        }
        this.logger.error("User with Mail [" + IdentifierUtils.clean((String)username) + "] doesn't exist.");
        throw new UserUnknownException();
    }

    public ProjectEntity findProject(String username, String projectId) throws UserUnknownException, UserRightsException, ProjectUnknownException {
        Assert.notNull((Object)projectId, (String)"projectId");
        ProjectEntity project = this.findProject(IdentifierUtils.clean((String)projectId));
        Optional user = this.userRepository.findByMail(IdentifierUtils.clean((String)username));
        if (!user.isPresent()) {
            this.logger.error("User with Mail [" + IdentifierUtils.clean((String)username) + "] doesn't exist");
            throw new UserUnknownException();
        }
        if (!project.hasOwner((UserEntity)user.get())) {
            this.logger.error("User with Mail [" + IdentifierUtils.clean((String)username) + "] hasn't rights for project [" + IdentifierUtils.clean((String)projectId) + "]");
            throw new UserRightsException();
        }
        return project;
    }

    public ProjectEntity findProject(String projectId) throws ProjectUnknownException {
        Optional optional = this.projectRepository.findById((Object)IdentifierUtils.clean((String)projectId));
        if (optional.isPresent()) {
            return (ProjectEntity)optional.get();
        }
        this.logger.error("Project with ID [" + IdentifierUtils.clean((String)projectId) + "] doesn't exist.");
        throw new ProjectUnknownException();
    }
}

