/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.messages.service;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smarti18n.exceptions.ProjectUnknownException;
import org.smarti18n.exceptions.UserRightsException;
import org.smarti18n.exceptions.UserUnknownException;
import org.smarti18n.messages.entities.MessageEntity;
import org.smarti18n.messages.entities.ProjectEntity;
import org.smarti18n.messages.repositories.MessageRepository;
import org.smarti18n.messages.service.EntityLoader;
import org.smarti18n.messages.service.MessageCache;
import org.smarti18n.messages.service.MessagesServiceImpl;
import org.springframework.stereotype.Component;

@Component
public class MessageCacheImpl
implements MessageCache {
    private final Logger logger = LoggerFactory.getLogger(MessagesServiceImpl.class);
    private final MessageRepository messageRepository;
    private final EntityLoader entityLoader;

    public MessageCacheImpl(MessageRepository messageRepository, EntityLoader entityLoader) {
        this.messageRepository = messageRepository;
        this.entityLoader = entityLoader;
    }

    public Collection<MessageEntity> findByProjectId(String projectId) throws ProjectUnknownException {
        ProjectEntity project = this.entityLoader.findProject(projectId);
        return this.findByProject(project);
    }

    public Collection<MessageEntity> findByUsernameAndProjectId(String username, String projectId) throws ProjectUnknownException, UserUnknownException, UserRightsException {
        ProjectEntity project = this.entityLoader.findProject(username, projectId);
        return this.findByProject(project);
    }

    private Collection<MessageEntity> findByProject(ProjectEntity project) {
        Long startTime = System.currentTimeMillis();
        Collection messages = this.messageRepository.findByIdProject(project);
        Long endTime = System.currentTimeMillis();
        this.logger.info("find messages by project in " + (endTime - startTime) + "ms");
        return messages;
    }
}

