/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.messages.service;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smarti18n.exceptions.MessageExistException;
import org.smarti18n.exceptions.MessageUnknownException;
import org.smarti18n.exceptions.ProjectUnknownException;
import org.smarti18n.exceptions.UserRightsException;
import org.smarti18n.exceptions.UserUnknownException;
import org.smarti18n.messages.entities.MessageEntity;
import org.smarti18n.messages.entities.ProjectEntity;
import org.smarti18n.messages.repositories.MessageRepository;
import org.smarti18n.messages.service.EntityLoader;
import org.smarti18n.messages.service.IdentifierUtils;
import org.smarti18n.messages.service.MessageCache;
import org.smarti18n.messages.service.MessagesService;
import org.smarti18n.models.Message;
import org.smarti18n.models.MessageImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessagesServiceImpl
implements MessagesService {
    private final MessageCache messageCache;
    private final MessageRepository messageRepository;
    private final EntityLoader entityLoader;
    private final Logger logger = LoggerFactory.getLogger(MessagesServiceImpl.class);

    public MessagesServiceImpl(MessageCache messageCache, MessageRepository messageRepository, EntityLoader entityLoader) {
        this.messageCache = messageCache;
        this.messageRepository = messageRepository;
        this.entityLoader = entityLoader;
    }

    @Transactional
    public Collection<Message> findAll(String username, String projectId) throws ProjectUnknownException, UserUnknownException, UserRightsException {
        Collection messages = this.messageCache.findByUsernameAndProjectId(username, projectId);
        return messages.stream().map(messageEntity -> new MessageImpl(messageEntity.getKey(), messageEntity.getTranslations())).sorted(Comparator.comparing(MessageImpl::getKey)).collect(Collectors.toList());
    }

    @Transactional
    public Message findOne(String username, String projectId, String key) throws ProjectUnknownException, UserUnknownException, UserRightsException {
        ProjectEntity project = this.entityLoader.findProject(username, projectId);
        Optional messageEntity = this.messageRepository.findById((Object)new MessageEntity.MessageId(IdentifierUtils.clean((String)key), project));
        if (messageEntity.isPresent()) {
            MessageImpl message = new MessageImpl((Message)messageEntity.get());
            project.getLocales().forEach(locale -> message.getTranslations().putIfAbsent(locale, ""));
            return message;
        }
        return null;
    }

    @Transactional
    public Message insert(String username, String projectId, String key) throws MessageExistException, ProjectUnknownException, UserUnknownException, UserRightsException {
        ProjectEntity project;
        String cleanKey = IdentifierUtils.clean((String)key.trim());
        if (this.messageRepository.findById((Object)new MessageEntity.MessageId(cleanKey, project = this.entityLoader.findProject(username, projectId))).isPresent()) {
            this.logger.error("Message with key [" + cleanKey + "] already exist.");
            throw new MessageExistException();
        }
        return new MessageImpl((Message)this.messageRepository.insert((Object)new MessageEntity(cleanKey, project)));
    }

    @Transactional
    public Message update(String username, String projectId, String key, Locale locale, String translation) throws ProjectUnknownException, UserUnknownException, UserRightsException {
        String cleanKey = IdentifierUtils.clean((String)key);
        ProjectEntity project = this.entityLoader.findProject(username, projectId);
        Optional optional = this.messageRepository.findById((Object)new MessageEntity.MessageId(cleanKey, project));
        MessageEntity messageEntity = optional.orElseGet(() -> new MessageEntity(cleanKey, project));
        messageEntity.putTranslation(locale, translation);
        MessageEntity saved = (MessageEntity)this.messageRepository.save((Object)messageEntity);
        return new MessageImpl(saved.getKey(), saved.getTranslations());
    }

    @Transactional
    public Message update(String username, String projectId, Message message) throws MessageUnknownException, ProjectUnknownException, UserUnknownException, UserRightsException {
        ProjectEntity project = this.entityLoader.findProject(username, projectId);
        Optional optional = this.messageRepository.findById((Object)new MessageEntity.MessageId(message.getKey(), project));
        if (!optional.isPresent()) {
            this.logger.error("Message with key [" + message.getKey() + "] and Project [" + projectId + "] doesn't exist!");
            throw new MessageUnknownException();
        }
        MessageEntity messageEntity = (MessageEntity)optional.get();
        messageEntity.setTranslations(message.getTranslations());
        return (Message)this.messageRepository.save((Object)messageEntity);
    }

    @Transactional
    public Message copy(String username, String projectId, String sourceKey, String targetKey) throws MessageExistException, MessageUnknownException, ProjectUnknownException, UserUnknownException, UserRightsException {
        ProjectEntity project = this.entityLoader.findProject(username, projectId);
        Optional optional = this.messageRepository.findById((Object)new MessageEntity.MessageId(IdentifierUtils.clean((String)sourceKey), project));
        if (!optional.isPresent()) {
            this.logger.error("Message with key [" + sourceKey + "] and Project [" + projectId + "] doesn't exist!");
            throw new MessageUnknownException();
        }
        String cleanedTargetKey = IdentifierUtils.clean((String)targetKey);
        if (this.messageRepository.findById((Object)new MessageEntity.MessageId(cleanedTargetKey, project)).isPresent()) {
            this.logger.error("Message with key [" + cleanedTargetKey + "] already exist.");
            throw new MessageExistException();
        }
        MessageEntity messageEntity = (MessageEntity)optional.get();
        messageEntity.setKey(cleanedTargetKey);
        MessageEntity saved = (MessageEntity)this.messageRepository.save((Object)messageEntity);
        return new MessageImpl(saved.getKey(), saved.getTranslations());
    }

    @Transactional
    public void remove(String username, String projectId, String key) throws ProjectUnknownException, UserUnknownException, UserRightsException {
        ProjectEntity project = this.entityLoader.findProject(username, projectId);
        this.messageRepository.deleteById((Object)new MessageEntity.MessageId(IdentifierUtils.clean((String)key), project));
    }

    @Transactional
    public Map<String, Map<Locale, String>> findForSpringMessageSource(String projectId) throws ProjectUnknownException {
        Collection messages = this.getMessagesForSource(projectId);
        HashMap<String, Map<Locale, String>> map = new HashMap<String, Map<Locale, String>>();
        for (MessageEntity message : messages) {
            map.put(message.getKey(), new HashMap(message.getTranslations()));
        }
        return map;
    }

    @Transactional
    public Map<String, String> findForAngularMessageSource(String projectId, Locale locale) throws ProjectUnknownException {
        Collection messages = this.getMessagesForSource(projectId);
        HashMap<String, String> map = new HashMap<String, String>();
        for (MessageEntity message : messages) {
            if (message.getTranslations().containsKey(locale)) {
                map.put(message.getKey(), message.getTranslation(locale));
            }
            Locale languageLocale = new Locale(locale.getLanguage());
            if (!message.getTranslations().containsKey(languageLocale)) continue;
            map.put(message.getKey(), message.getTranslation(languageLocale));
        }
        return map;
    }

    private Collection<MessageEntity> getMessagesForSource(String projectId) {
        ProjectEntity project = this.entityLoader.findProject(projectId);
        LinkedHashSet<MessageEntity> messages = new LinkedHashSet<MessageEntity>();
        if (project.getParentProject() != null) {
            messages.addAll(this.messageCache.findByProjectId(project.getParentProject().getId()));
        }
        messages.addAll(this.messageCache.findByProjectId(projectId));
        return messages;
    }
}

