/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.messages.service;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smarti18n.exceptions.ProjectExistException;
import org.smarti18n.exceptions.ProjectUnknownException;
import org.smarti18n.exceptions.UserRightsException;
import org.smarti18n.exceptions.UserUnknownException;
import org.smarti18n.messages.entities.ProjectEntity;
import org.smarti18n.messages.entities.UserEntity;
import org.smarti18n.messages.repositories.ProjectRepository;
import org.smarti18n.messages.service.EntityLoader;
import org.smarti18n.messages.service.IdentifierUtils;
import org.smarti18n.messages.service.ProjectsService;
import org.smarti18n.messages.service.SmartKeyGenerator;
import org.smarti18n.models.Project;
import org.smarti18n.models.ProjectImpl;
import org.smarti18n.models.UserRole;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class ProjectsServiceImpl
implements ProjectsService {
    private final ProjectRepository projectRepository;
    private final SmartKeyGenerator smartKeyGenerator;
    private final EntityLoader entityLoader;
    private final Logger logger = LoggerFactory.getLogger(ProjectsServiceImpl.class);

    public ProjectsServiceImpl(ProjectRepository projectRepository, SmartKeyGenerator smartKeyGenerator, EntityLoader entityLoader) {
        this.projectRepository = projectRepository;
        this.smartKeyGenerator = smartKeyGenerator;
        this.entityLoader = entityLoader;
    }

    @Transactional
    public List<Project> findAll(String username) throws UserUnknownException {
        UserEntity user = this.entityLoader.findUser(username);
        if (user.getRole() == UserRole.SUPERUSER) {
            return this.projectRepository.findAll().stream().collect(Collectors.toList());
        }
        return this.projectRepository.findByOwners(user).stream().collect(Collectors.toList());
    }

    @Transactional
    public Project findOne(String username, String projectId) throws UserRightsException, UserUnknownException {
        UserEntity user = this.entityLoader.findUser(username);
        Optional optional = this.projectRepository.findById((Object)IdentifierUtils.clean((String)projectId));
        if (!optional.isPresent()) {
            return null;
        }
        ProjectEntity project = (ProjectEntity)optional.get();
        if (project.hasOwner(user)) {
            return project;
        }
        this.logger.error("User with Mail [" + IdentifierUtils.clean((String)username) + "] hasn't rights for project [" + IdentifierUtils.clean((String)projectId) + "]");
        throw new UserRightsException();
    }

    @Transactional
    public Project insert(String username, String projectId, String parentProjectId) throws ProjectExistException, UserUnknownException {
        String cleanedProjectId = IdentifierUtils.clean((String)projectId);
        if (this.projectRepository.findById((Object)cleanedProjectId).isPresent()) {
            this.logger.error("Project with id [" + cleanedProjectId + "] already exist.");
            throw new ProjectExistException();
        }
        String secret = this.smartKeyGenerator.generateKey();
        ProjectEntity newProject = new ProjectEntity(cleanedProjectId, secret, this.entityLoader.findUser(username));
        if (!StringUtils.isEmpty((Object)parentProjectId)) {
            ProjectEntity parentProject = this.entityLoader.findProject(username, parentProjectId);
            newProject.setParentProject(parentProject);
        }
        ProjectEntity projectEntity = (ProjectEntity)this.projectRepository.insert((Object)newProject);
        return new ProjectImpl((Project)projectEntity);
    }

    @Transactional
    public Project update(String username, Project project) throws ProjectUnknownException, UserUnknownException, UserRightsException {
        ProjectEntity projectEntity = this.entityLoader.findProject(username, project.getId());
        projectEntity.setName(project.getName());
        projectEntity.setDescription(project.getDescription());
        projectEntity.setLocales(project.getLocales() == null ? new HashSet() : new HashSet(project.getLocales()));
        return new ProjectImpl((Project)this.projectRepository.save((Object)projectEntity));
    }

    public void remove(String username, String projectId) throws ProjectUnknownException, UserUnknownException, UserRightsException {
        ProjectEntity project = this.entityLoader.findProject(username, projectId);
        this.projectRepository.delete((Object)project);
    }
}

