/*
 * Decompiled with CFR 0.152.
 */
package org.smarti18n.messages.service;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smarti18n.exceptions.UserExistException;
import org.smarti18n.exceptions.UserUnknownException;
import org.smarti18n.messages.entities.UserEntity;
import org.smarti18n.messages.repositories.UserRepository;
import org.smarti18n.messages.service.ProjectsServiceImpl;
import org.smarti18n.messages.service.UserService;
import org.smarti18n.models.User;
import org.smarti18n.models.UserRole;
import org.smarti18n.models.UserSimplified;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UserServiceImpl
implements UserService {
    private final UserRepository userRepository;
    private final PasswordEncoder passwordEncoder;
    private final Logger logger = LoggerFactory.getLogger(ProjectsServiceImpl.class);

    public UserServiceImpl(UserRepository userRepository, PasswordEncoder passwordEncoder) {
        this.userRepository = userRepository;
        this.passwordEncoder = passwordEncoder;
    }

    @Transactional
    public List<User> findAll() {
        return this.userRepository.findAll().stream().collect(Collectors.toList());
    }

    @Transactional
    public User findOne(String mail) throws UserUnknownException {
        Optional optional = this.userRepository.findByMail(mail);
        if (!optional.isPresent()) {
            this.logger.error("User with mail [" + mail + "] doesn't exist.");
            throw new UserUnknownException();
        }
        return (User)optional.get();
    }

    @Transactional
    public UserSimplified findOneSimplified(String mail) {
        return this.userRepository.findByMail(mail).map(UserSimplified::new).orElse(null);
    }

    @Transactional
    public User register(String mail, String password) throws UserExistException {
        if (this.userRepository.findByMail(mail).isPresent()) {
            this.logger.error("User with Mail [" + mail + "] already exist!");
            throw new UserExistException();
        }
        boolean firstUser = this.userRepository.count() == 0L;
        UserRole role = firstUser ? UserRole.SUPERUSER : UserRole.USER;
        String encodedPassword = this.passwordEncoder.encode((CharSequence)password);
        return (User)this.userRepository.insert((Object)new UserEntity(mail, encodedPassword, role));
    }

    @Transactional
    public User update(User user) throws UserUnknownException {
        Optional optional = this.userRepository.findByMail(user.getMail());
        if (!optional.isPresent()) {
            this.logger.error("User with mail [" + user.getMail() + "] doesn't exist.");
            throw new UserUnknownException();
        }
        UserEntity userEntity = (UserEntity)optional.get();
        userEntity.setVorname(user.getVorname());
        userEntity.setNachname(user.getNachname());
        userEntity.setCompany(user.getCompany());
        return (User)this.userRepository.save((Object)userEntity);
    }
}

