/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.edifact;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.ValidationMode;
import org.apache.daffodil.lib.util.Misc;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.resource.config.Parameter;
import org.smooks.cartridges.dfdl.DataProcessorFactory;
import org.smooks.cartridges.dfdl.DfdlSchema;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class EdifactDataProcessorFactory
extends DataProcessorFactory {
    private static final Mustache MUSTACHE;
    @Inject
    protected ApplicationContext applicationContext;

    public DataProcessor createDataProcessor() {
        try {
            URI entrySchemaUri;
            final Parameter schemaUriParameter = this.resourceConfig.getParameter("schemaUri", String.class);
            String version = this.readVersion((Parameter<String>)schemaUriParameter);
            List messageTypeParameters = this.resourceConfig.getParameters("messageType");
            if (messageTypeParameters == null || messageTypeParameters.isEmpty()) {
                entrySchemaUri = new URI("/" + version.toLowerCase() + "/EDIFACT-Interchange.dfdl.xsd");
            } else {
                List<String> messageTypes = messageTypeParameters.stream().map(Parameter::getValue).collect(Collectors.toList());
                entrySchemaUri = this.materialiseEntrySchema((String)schemaUriParameter.getValue(), messageTypes, version);
            }
            DfdlSchema dfdlSchema = new DfdlSchema(entrySchemaUri, ValidationMode.valueOf((String)((String)this.resourceConfig.getParameterValue("validationMode", String.class, (Object)"Off"))), Boolean.parseBoolean((String)this.resourceConfig.getParameterValue("cacheOnDisk", String.class, (Object)"false")), Boolean.parseBoolean((String)this.resourceConfig.getParameterValue("debugging", String.class, (Object)"false")), (String)this.resourceConfig.getParameterValue("distinguishedRootNode", String.class), (String)this.resourceConfig.getParameterValue("schematronUrl", String.class), Boolean.parseBoolean((String)this.resourceConfig.getParameterValue("schematronValidation", String.class))){

                public String getName() {
                    return (String)schemaUriParameter.getValue() + ":" + this.getValidationMode() + ":" + this.isCacheOnDisk() + ":" + this.isDebugging();
                }
            };
            return this.compileOrGet(dfdlSchema);
        }
        catch (FileNotFoundException t) {
            throw new SmooksConfigException(t.getMessage() + " Hint: are you sure you have added the right EDIFACT schema pack to the Java classpath?", (Throwable)t);
        }
        catch (Throwable t) {
            throw new SmooksConfigException(t);
        }
    }

    protected URI materialiseEntrySchema(final String schemaUri, final List<String> messageTypes, final String version) throws IOException {
        File generatedEntrySchemaDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        generatedEntrySchemaDir.deleteOnExit();
        File generatedEntrySchema = new File(generatedEntrySchemaDir + "/EDIFACT-Interchange-" + UUID.nameUUIDFromBytes(String.join((CharSequence)":", messageTypes).getBytes()) + ".dfdl.xsd");
        try (OutputStreamWriter fileWriter = new OutputStreamWriter(Files.newOutputStream(generatedEntrySchema.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            MUSTACHE.execute((Writer)fileWriter, (Object)new HashMap<String, Object>(){
                {
                    this.put("schemaLocation", schemaUri);
                    this.put("messageTypes", messageTypes);
                    this.put("version", version);
                }
            });
        }
        return generatedEntrySchema.toURI();
    }

    protected String readVersion(Parameter<String> schemaUriParameter) throws XPathExpressionException, ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(Misc.getRequiredResource((String)((String)schemaUriParameter.getValue())).toString());
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        return (String)xpath.compile("/schema/annotation/appinfo[@source='http://www.ibm.com/dfdl/edi/un/edifact']/text()").evaluate(document, XPathConstants.STRING);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    static {
        try {
            MUSTACHE = new DefaultMustacheFactory().compile("EDIFACT-Common/EDIFACT-Interchange.dfdl.xsd.mustache");
        }
        catch (Throwable t) {
            throw new SmooksConfigException(t);
        }
    }
}

