/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.camel.dataformat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Function;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Service;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.DataFormat;
import org.smooks.Smooks;
import org.smooks.SmooksFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.engine.lookup.ExportsLookup;
import org.smooks.io.payload.Exports;
import org.smooks.io.payload.JavaSource;
import org.smooks.io.payload.StringResult;
import org.xml.sax.SAXException;

public class SmooksDataFormat
implements DataFormat,
CamelContextAware,
Service {
    private Smooks smooks;
    private CamelContext camelContext;
    private final String smooksConfig;

    public SmooksDataFormat(String smooksConfig) throws Exception {
        this.smooksConfig = smooksConfig;
    }

    public void marshal(Exchange exchange, Object fromBody, OutputStream toStream) throws Exception {
        ExecutionContext execContext = this.smooks.createExecutionContext();
        TypeConverter typeConverter = exchange.getContext().getTypeConverter();
        JavaSource source = (JavaSource)typeConverter.mandatoryConvertTo(JavaSource.class, exchange, fromBody);
        StringResult stringResult = new StringResult();
        this.smooks.filterSource(execContext, (Source)source, new Result[]{stringResult});
        toStream.write(stringResult.getResult().getBytes(execContext.getContentEncoding()));
    }

    public Object unmarshal(Exchange exchange, InputStream fromStream) {
        ExecutionContext execContext = this.smooks.createExecutionContext();
        Exports exports = (Exports)this.smooks.getApplicationContext().getRegistry().lookup((Function)new ExportsLookup());
        Result[] results = exports.createResults();
        this.smooks.filterSource(execContext, (Source)new StreamSource(fromStream), results);
        return this.getResult(exports, results, exchange);
    }

    protected Object getResult(Exports exports, Result[] results, Exchange exchange) {
        List objects = Exports.extractResults((Result[])results, (Exports)exports);
        if (objects.size() == 1) {
            return objects.get(0);
        }
        return objects;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void start() {
        SmooksFactory smooksFactory = (SmooksFactory)this.camelContext.getRegistry().lookupByName(SmooksFactory.class.getName());
        try {
            this.smooks = smooksFactory != null ? smooksFactory.createInstance(this.smooksConfig) : new Smooks(this.smooksConfig);
        }
        catch (IOException | SAXException e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    public void stop() {
        if (this.smooks != null) {
            this.smooks.close();
        }
    }
}

