/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.camel.routing;

import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleObserver;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.expression.ExecutionContextExpressionEvaluator;
import org.smooks.api.lifecycle.ExecutionLifecycleCleanable;
import org.smooks.api.lifecycle.ExecutionLifecycleInitializable;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.camel.routing.BeanRouterObserver;
import org.smooks.cartridges.javabean.BeanMapExpressionEvaluator;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.smooks.support.FreeMarkerTemplate;
import org.smooks.support.FreeMarkerUtils;
import org.w3c.dom.Element;

public class BeanRouter
implements AfterVisitor,
Consumer,
ExecutionLifecycleInitializable,
ExecutionLifecycleCleanable {
    @Inject
    private String beanId;
    @Inject
    private String toEndpoint;
    @Inject
    private Optional<String> condition;
    @Inject
    private Optional<String> correlationIdName;
    @Inject
    private Optional<FreeMarkerTemplate> correlationIdPattern;
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    ResourceConfig resourceConfig;
    private ProducerTemplate producerTemplate;
    private BeanRouterObserver camelRouterObserable;
    private CamelContext camelContext;

    public BeanRouter() {
    }

    public BeanRouter(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @PostConstruct
    public void postConstruct() {
        if (this.resourceConfig == null) {
            this.resourceConfig = new DefaultResourceConfig();
        }
        this.producerTemplate = this.getCamelContext().createProducerTemplate();
        if (this.isBeanRoutingConfigured()) {
            this.camelRouterObserable = new BeanRouterObserver(this, this.beanId);
            if (this.condition != null && this.condition.isPresent()) {
                this.camelRouterObserable.setConditionEvaluator((ExecutionContextExpressionEvaluator)new BeanMapExpressionEvaluator(this.condition.get()));
            }
        }
        if (this.correlationIdName != null && this.correlationIdName.isPresent() && (this.correlationIdPattern == null || !this.correlationIdPattern.isPresent())) {
            throw new SmooksConfigException("Camel router component configured with a 'correlationIdName', but 'correlationIdPattern' is not configured.");
        }
        if ((this.correlationIdName == null || !this.correlationIdName.isPresent()) && this.correlationIdPattern != null && this.correlationIdPattern.isPresent()) {
            throw new SmooksConfigException("Camel router component configured with a 'correlationIdPattern', but 'correlationIdName' is not configured.");
        }
    }

    public BeanRouter setBeanId(String beanId) {
        this.beanId = beanId;
        return this;
    }

    public BeanRouter setToEndpoint(String toEndpoint) {
        this.toEndpoint = toEndpoint;
        return this;
    }

    public BeanRouter setCorrelationIdName(String correlationIdName) {
        AssertArgument.isNotNullAndNotEmpty((String)correlationIdName, (String)"correlationIdName");
        this.correlationIdName = Optional.of(correlationIdName);
        return this;
    }

    public BeanRouter setCorrelationIdPattern(String correlationIdPattern) {
        this.correlationIdPattern = Optional.of(new FreeMarkerTemplate(correlationIdPattern));
        return this;
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        Object bean = this.getBeanFromExecutionContext(executionContext, this.beanId);
        this.sendBean(bean, executionContext);
    }

    protected void sendBean(Object bean, ExecutionContext execContext) {
        try {
            if (this.correlationIdPattern != null && this.correlationIdPattern.isPresent()) {
                Processor processor = exchange -> {
                    Message in = exchange.getIn();
                    in.setBody(bean);
                    in.setHeader((String)this.correlationIdName.orElse(null), (Object)this.correlationIdPattern.get().apply((Object)FreeMarkerUtils.getMergedModel((ExecutionContext)execContext)));
                };
                this.producerTemplate.send(this.toEndpoint, processor);
            } else {
                this.producerTemplate.sendBodyAndHeaders(this.toEndpoint, bean, execContext.getBeanContext().getBeanMap());
            }
        }
        catch (Exception e) {
            throw new SmooksException("Exception routing beanId '" + this.beanId + "' to endpoint '" + this.toEndpoint + "'.", (Throwable)e);
        }
    }

    private Object getBeanFromExecutionContext(ExecutionContext execContext, String beanId) {
        Object bean = execContext.getBeanContext().getBean(beanId);
        if (bean == null) {
            throw new SmooksException("Exception routing beanId '" + beanId + "'. The bean was not found in the Smooks ExceutionContext.");
        }
        return bean;
    }

    private CamelContext getCamelContext() {
        if (this.camelContext == null) {
            return (CamelContext)this.applicationContext.getRegistry().lookup(CamelContext.class);
        }
        return this.camelContext;
    }

    private boolean isBeanRoutingConfigured() {
        return "none".equals(this.resourceConfig.getSelectorPath().getSelector());
    }

    @PreDestroy
    public void preDestroy() {
        try {
            this.producerTemplate.stop();
        }
        catch (Exception e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean consumes(Object object) {
        return this.beanId.equals(object);
    }

    public void executeExecutionLifecycleInitialize(ExecutionContext executionContext) {
        if (this.isBeanRoutingConfigured()) {
            executionContext.getBeanContext().addObserver((BeanContextLifecycleObserver)this.camelRouterObserable);
        }
    }

    public void executeExecutionLifecycleCleanup(ExecutionContext executionContext) {
        if (this.isBeanRoutingConfigured()) {
            executionContext.getBeanContext().removeObserver((BeanContextLifecycleObserver)this.camelRouterObserable);
        }
    }
}

