/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.camel.converters;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Source;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.smooks.cartridges.camel.converters.SourceConverter;
import org.smooks.io.payload.JavaResult;
import org.smooks.io.payload.JavaSource;
import org.smooks.io.payload.JavaSourceWithoutEventStream;

public final class SourceConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        SourceConverterLoader.addTypeConverter(registry, Source.class, InputStream.class, false, (type, exchange, value) -> SourceConverter.toStreamSource((InputStream)value));
        SourceConverterLoader.addTypeConverter(registry, Source.class, GenericFile.class, false, (type, exchange, value) -> SourceConverter.toStreamSource((GenericFile<File>)((GenericFile)value)));
        SourceConverterLoader.addTypeConverter(registry, JavaSource.class, JavaResult.class, false, (type, exchange, value) -> SourceConverter.toJavaSource((JavaResult)value));
        SourceConverterLoader.addTypeConverter(registry, JavaSource.class, Object.class, false, (type, exchange, value) -> SourceConverter.toJavaSource(value));
        SourceConverterLoader.addTypeConverter(registry, JavaSourceWithoutEventStream.class, Object.class, false, (type, exchange, value) -> SourceConverter.toJavaSourceWithoutEventStream(value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

