/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.camel.processor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.WrappedFile;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.Smooks;
import org.smooks.SmooksFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.delivery.VisitorAppender;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.engine.lookup.ExportsLookup;
import org.smooks.engine.report.HtmlReportGenerator;
import org.smooks.io.payload.Exports;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SmooksProcessor
implements Processor,
Service,
CamelContextAware {
    public static final String SMOOKS_EXECUTION_CONTEXT = "CamelSmooksExecutionContext";
    public static final String CAMEL_CHARACTER_ENCODING = "CamelCharsetName";
    private static final Logger LOGGER = LoggerFactory.getLogger(SmooksProcessor.class);
    public static final TypedKey<Exchange> EXCHANGE_TYPED_KEY = TypedKey.of();
    private Smooks smooks;
    private String configUri;
    private String reportPath;
    private Set<VisitorAppender> visitorAppenders = new HashSet<VisitorAppender>();
    private Map<String, Visitor> selectorVisitorMap = new HashMap<String, Visitor>();
    private CamelContext camelContext;
    private boolean attachmentsSupported = false;

    public SmooksProcessor(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public SmooksProcessor(Smooks smooks, CamelContext camelContext) {
        this(camelContext);
        this.smooks = smooks;
    }

    public SmooksProcessor(String configUri, CamelContext camelContext) throws IOException, SAXException {
        this(camelContext);
        this.configUri = configUri;
    }

    public void process(Exchange exchange) {
        exchange.getMessage().setHeaders(exchange.getIn().getHeaders());
        if (this.attachmentsSupported && ((AttachmentMessage)exchange.getIn(AttachmentMessage.class)).hasAttachments()) {
            for (Map.Entry attachmentObject : ((AttachmentMessage)exchange.getIn(AttachmentMessage.class)).getAttachmentObjects().entrySet()) {
                ((AttachmentMessage)exchange.getMessage(AttachmentMessage.class)).addAttachmentObject((String)attachmentObject.getKey(), (Attachment)attachmentObject.getValue());
            }
        }
        ExecutionContext executionContext = this.smooks.createExecutionContext();
        executionContext.put(EXCHANGE_TYPED_KEY, (Object)exchange);
        String charsetName = (String)exchange.getProperty(CAMEL_CHARACTER_ENCODING);
        if (charsetName != null) {
            executionContext.setContentEncoding(charsetName);
        }
        exchange.getIn().setHeader(SMOOKS_EXECUTION_CONTEXT, (Object)executionContext);
        this.setupSmooksReporting(executionContext);
        Exports exports = (Exports)this.smooks.getApplicationContext().getRegistry().lookup((Function)new ExportsLookup());
        if (exports.hasExports()) {
            Result[] results = exports.createResults();
            this.smooks.filterSource(executionContext, this.getSource(exchange), results);
            this.setResultOnBody(exports, results, exchange);
        } else {
            this.smooks.filterSource(executionContext, this.getSource(exchange), new Result[0]);
        }
        executionContext.remove(EXCHANGE_TYPED_KEY);
    }

    protected void setResultOnBody(Exports exports, Result[] results, Exchange exchange) {
        Message message = exchange.getMessage();
        List objects = Exports.extractResults((Result[])results, (Exports)exports);
        if (objects.size() == 1) {
            Object value = objects.get(0);
            message.setBody(value);
        } else {
            message.setBody((Object)objects);
        }
    }

    private void setupSmooksReporting(ExecutionContext executionContext) {
        if (this.reportPath != null) {
            try {
                executionContext.getContentDeliveryRuntime().addExecutionEventListener((ExecutionEventListener)new HtmlReportGenerator(this.reportPath, executionContext.getApplicationContext()));
            }
            catch (IOException e) {
                LOGGER.info("Could not generate Smooks Report. The reportPath specified was [" + this.reportPath + "].", (Throwable)e);
            }
        }
    }

    private Source getSource(Exchange exchange) {
        Object payload = exchange.getIn().getBody();
        if (payload instanceof SAXSource) {
            return new StreamSource((Reader)((Object)((SAXSource)payload).getXMLReader()));
        }
        if (payload instanceof Source) {
            return (Source)payload;
        }
        if (payload instanceof Node) {
            return new DOMSource((Node)payload);
        }
        if (payload instanceof InputStream) {
            return new StreamSource((InputStream)payload);
        }
        if (payload instanceof Reader) {
            return new StreamSource((Reader)payload);
        }
        if (payload instanceof WrappedFile) {
            return new StreamSource((File)((WrappedFile)exchange.getIn().getBody(WrappedFile.class)).getFile());
        }
        return (Source)exchange.getIn().getBody(Source.class);
    }

    public String getSmooksConfig() {
        return this.configUri;
    }

    public void setSmooksConfig(String smooksConfig) {
        this.configUri = smooksConfig;
    }

    public SmooksProcessor addVisitor(Visitor visitor, String targetSelector) {
        this.selectorVisitorMap.put(targetSelector, visitor);
        return this;
    }

    public SmooksProcessor addVisitor(VisitorAppender appender) {
        this.visitorAppenders.add(appender);
        return this;
    }

    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    public void start() {
        try {
            if (this.smooks == null) {
                this.smooks = this.createSmooks();
                if (this.configUri != null) {
                    this.smooks.addResourceConfigs(this.configUri);
                }
                this.smooks.getApplicationContext().getRegistry().registerObject(CamelContext.class, (Object)this.camelContext);
            }
            this.addAppenders(this.smooks, this.visitorAppenders);
            this.addVisitors(this.smooks, this.selectorVisitorMap);
            InputStream inputStream = null;
            try {
                inputStream = this.camelContext.getClassResolver().loadResourceAsStream("META-INF/services/org/apache/camel/other.properties");
                if (inputStream != null) {
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    if (properties.getProperty("name") != null && properties.getProperty("name").equals("attachments")) {
                        this.attachmentsSupported = true;
                    }
                }
            }
            finally {
                if (!this.attachmentsSupported) {
                    LOGGER.warn("Attachments module could not be found: attachments will not be propagated");
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            LOGGER.info(this + " Started");
        }
        catch (IOException | SAXException e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    private Smooks createSmooks() {
        SmooksFactory smooksFactory = (SmooksFactory)this.camelContext.getRegistry().lookupByName(SmooksFactory.class.getName());
        return smooksFactory != null ? smooksFactory.createInstance() : new Smooks();
    }

    private void addAppenders(Smooks smooks, Set<VisitorAppender> visitorAppenders) {
        for (VisitorAppender appender : visitorAppenders) {
            smooks.addVisitors(appender);
        }
    }

    private void addVisitors(Smooks smooks, Map<String, Visitor> selectorVisitorMap) {
        for (Map.Entry<String, Visitor> entry : selectorVisitorMap.entrySet()) {
            smooks.addVisitor(entry.getValue(), entry.getKey());
        }
    }

    public void stop() {
        if (this.smooks != null) {
            this.smooks.close();
            this.smooks = null;
        }
        LOGGER.info(this + " Stopped");
    }

    public String toString() {
        return "SmooksProcessor [configUri=" + this.configUri + "]";
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

