/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.csv;

import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.smooks.cartridges.csv.CSVHeaderValidationException;
import org.smooks.cartridges.csv.CSVRecordParserFactory;
import org.smooks.cartridges.flatfile.variablefield.VariableFieldRecordParser;
import org.xml.sax.InputSource;

public class CSVRecordParser<T extends CSVRecordParserFactory>
extends VariableFieldRecordParser<T> {
    private CSVReader csvLineReader;

    public void setDataSource(InputSource source) {
        Reader reader = source.getCharacterStream();
        if (reader == null) {
            throw new IllegalStateException("Invalid InputSource type supplied to CSVRecordParser.  Must contain a Reader instance.");
        }
        CSVRecordParserFactory factory = (CSVRecordParserFactory)this.getFactory();
        this.csvLineReader = new CSVReaderBuilder(reader).withCSVParser((ICSVParser)new CSVParserBuilder().withSeparator(factory.getSeparator()).withQuoteChar(factory.getQuoteChar()).withEscapeChar(factory.getEscapeChar()).build()).build();
    }

    public List<String> nextRecordFieldValues() throws IOException {
        String[] csvRecord;
        try {
            csvRecord = this.csvLineReader.readNext();
        }
        catch (CsvValidationException e) {
            throw new IOException(e);
        }
        if (csvRecord == null) {
            return null;
        }
        return Arrays.asList(csvRecord);
    }

    protected void validateHeader(List<String> headers) {
        try {
            super.validateHeader(headers);
        }
        catch (IOException e) {
            throw new CSVHeaderValidationException(((CSVRecordParserFactory)this.getFactory()).getRecordMetaData().getFieldNames(), headers);
        }
    }
}

