/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.dfdl.unparser;

import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import javax.inject.Inject;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.daffodil.japi.DaffodilUnparseContentHandler;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.Diagnostic;
import org.apache.daffodil.japi.UnparseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.sax.StreamResultWriter;
import org.smooks.api.memento.Memento;
import org.smooks.api.memento.MementoCaretaker;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.api.resource.visitor.sax.ng.ChildrenVisitor;
import org.smooks.cartridges.dfdl.unparser.DaffodilUnparseContentHandlerMemento;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.io.Stream;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

@StreamResultWriter
public class DfdlUnparser
implements BeforeVisitor,
AfterVisitor,
ChildrenVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DfdlUnparser.class);
    private final DataProcessor dataProcessor;
    @Inject
    private String schemaURI;

    public DfdlUnparser(DataProcessor dataProcessor) {
        this.dataProcessor = dataProcessor;
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        DaffodilUnparseContentHandlerMemento daffodilUnparseContentHandlerMemento = this.getOrCreateDaffodilUnparseContentHandlerMemento(element, executionContext);
        DaffodilUnparseContentHandler daffodilUnparseContentHandler = daffodilUnparseContentHandlerMemento.getDaffodilUnparseContentHandler();
        if (element.getPrefix() == null || element.getPrefix().equals("")) {
            daffodilUnparseContentHandler.endElement("", element.getLocalName(), element.getLocalName());
        } else {
            daffodilUnparseContentHandler.endElement(element.getNamespaceURI(), element.getLocalName(), element.getPrefix() + ":" + element.getLocalName());
        }
        this.throwIfError(daffodilUnparseContentHandler.getUnparseResult());
        if (daffodilUnparseContentHandlerMemento.getFragment().unwrap().equals(element)) {
            daffodilUnparseContentHandler.endDocument();
            this.throwIfError(daffodilUnparseContentHandler.getUnparseResult());
        }
    }

    protected DaffodilUnparseContentHandlerMemento getOrCreateDaffodilUnparseContentHandlerMemento(Node node, ExecutionContext executionContext) {
        MementoCaretaker mementoCaretaker = executionContext.getMementoCaretaker();
        for (Node parentNode = node; parentNode != null; parentNode = parentNode.getParentNode()) {
            DaffodilUnparseContentHandlerMemento daffodilUnparseContentHandlerMemento = new DaffodilUnparseContentHandlerMemento((Fragment<?>)new NodeFragment(parentNode), (Visitor)this);
            boolean exists = mementoCaretaker.exists((Memento)daffodilUnparseContentHandlerMemento);
            if (!exists) continue;
            mementoCaretaker.restore((Memento)daffodilUnparseContentHandlerMemento);
            return daffodilUnparseContentHandlerMemento;
        }
        WritableByteChannel writableByteChannel = Channels.newChannel((OutputStream)new WriterOutputStream(Stream.out((ExecutionContext)executionContext), executionContext.getContentEncoding(), 1024, true));
        DaffodilUnparseContentHandler daffodilUnparseContentHandler = this.dataProcessor.newContentHandlerInstance(writableByteChannel);
        daffodilUnparseContentHandler.startDocument();
        DaffodilUnparseContentHandlerMemento daffodilUnparseContentHandlerMemento = new DaffodilUnparseContentHandlerMemento((Fragment<?>)new NodeFragment(node), (Visitor)this);
        daffodilUnparseContentHandlerMemento.setDaffodilUnparseContentHandler(daffodilUnparseContentHandler);
        mementoCaretaker.capture((Memento)daffodilUnparseContentHandlerMemento);
        return daffodilUnparseContentHandlerMemento;
    }

    public void visitBefore(Element element, ExecutionContext executionContext) {
        DaffodilUnparseContentHandler daffodilUnparseContentHandler = this.getOrCreateDaffodilUnparseContentHandlerMemento(element, executionContext).getDaffodilUnparseContentHandler();
        AttributesImpl attributes = new AttributesImpl();
        if (element.getAttributes() != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                if (node.getPrefix() == null || node.getPrefix().equals("")) {
                    attributes.addAttribute("", node.getLocalName(), node.getNodeName(), String.valueOf(node.getNodeType()), node.getNodeValue());
                    continue;
                }
                attributes.addAttribute(node.getNamespaceURI(), node.getLocalName(), node.getNodeName(), String.valueOf(node.getNodeType()), node.getNodeValue());
            }
        }
        if (element.getPrefix() == null || element.getPrefix().equals("")) {
            daffodilUnparseContentHandler.startElement("", element.getLocalName(), element.getLocalName(), (Attributes)attributes);
        } else {
            daffodilUnparseContentHandler.startElement(element.getNamespaceURI(), element.getLocalName(), element.getPrefix() + ":" + element.getLocalName(), (Attributes)attributes);
        }
        this.throwIfError(daffodilUnparseContentHandler.getUnparseResult());
    }

    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) {
        DaffodilUnparseContentHandler daffodilUnparseContentHandler = this.getOrCreateDaffodilUnparseContentHandlerMemento(characterData, executionContext).getDaffodilUnparseContentHandler();
        daffodilUnparseContentHandler.characters(characterData.getData().toCharArray(), 0, characterData.getData().length());
        this.throwIfError(daffodilUnparseContentHandler.getUnparseResult());
    }

    public void visitChildElement(Element element, ExecutionContext executionContext) {
    }

    private void throwIfError(UnparseResult unparseResult) {
        if (unparseResult != null) {
            for (Diagnostic diagnostic : unparseResult.getDiagnostics()) {
                if (diagnostic.isError()) {
                    throw new SmooksException(diagnostic.getSomeMessage(), diagnostic.getSomeCause());
                }
                LOGGER.warn(diagnostic.getMessage());
            }
        }
    }
}

