/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.dfdl.parser;

import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.Diagnostic;
import org.apache.daffodil.japi.ParseResult;
import org.apache.daffodil.japi.infoset.InfosetOutputter;
import org.apache.daffodil.japi.io.InputSourceDataInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.reader.SmooksXMLReader;
import org.smooks.cartridges.dfdl.DataProcessorFactory;
import org.smooks.cartridges.dfdl.parser.ContentHandlerInfosetOutputter;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DfdlParser
implements SmooksXMLReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DfdlParser.class);
    protected DataProcessor dataProcessor;
    @Inject
    protected ApplicationContext applicationContext;
    @Inject
    private ResourceConfig resourceConfig;
    @Inject
    @Named(value="dataProcessorFactory")
    private Class<? extends DataProcessorFactory> dataProcessorFactoryClass;
    @Inject
    @Named(value="schemaURI")
    private String schemaUri;
    @Inject
    private Boolean indent = false;
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private DTDHandler dtdHandler;

    public void setExecutionContext(ExecutionContext executionContext) {
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @PostConstruct
    public void postConstruct() throws IllegalAccessException, InstantiationException {
        DataProcessorFactory dataProcessorFactory = this.dataProcessorFactoryClass.newInstance();
        ((LifecycleManager)this.applicationContext.getRegistry().lookup((Function)new LifecycleManagerLookup())).applyPhase((Object)dataProcessorFactory, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.applicationContext.getRegistry(), this.resourceConfig, (Object)dataProcessorFactory)));
        this.dataProcessor = dataProcessorFactory.createDataProcessor();
    }

    public void parse(InputSource input) {
        InputSourceDataInputStream inputSourceDataInputStream = new InputSourceDataInputStream(input.getByteStream());
        ParseResult parseResult = null;
        while (parseResult == null || !parseResult.location().isAtEnd()) {
            parseResult = this.dataProcessor.parse(inputSourceDataInputStream, (InfosetOutputter)new ContentHandlerInfosetOutputter(this.contentHandler, this.indent));
            if (parseResult.isError()) {
                for (Diagnostic diagnostic : parseResult.getDiagnostics()) {
                    if (diagnostic.isError()) {
                        throw new SmooksException(diagnostic.getSomeMessage(), diagnostic.getSomeCause());
                    }
                    LOGGER.debug(diagnostic.getSomeMessage());
                }
            }
            for (Diagnostic diagnostic : parseResult.getDiagnostics()) {
                LOGGER.debug(diagnostic.getSomeMessage());
            }
        }
    }

    public void parse(String systemId) {
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setIndent(Boolean indent) {
        this.indent = indent;
    }

    public Class<? extends DataProcessorFactory> getDataProcessorFactoryClass() {
        return this.dataProcessorFactoryClass;
    }

    public void setDataProcessorFactoryClass(Class<? extends DataProcessorFactory> dataProcessorFactoryClass) {
        this.dataProcessorFactoryClass = dataProcessorFactoryClass;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    public String getSchemaUri() {
        return this.schemaUri;
    }

    public void setSchemaUri(String schemaUri) {
        this.schemaUri = schemaUri;
    }
}

