/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.dfdl;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.daffodil.japi.Compiler;
import org.apache.daffodil.japi.Daffodil;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.Diagnostic;
import org.apache.daffodil.japi.ProcessorFactory;
import org.apache.daffodil.japi.ValidationMode;
import org.apache.daffodil.japi.debugger.DebuggerRunner;
import org.apache.daffodil.japi.debugger.TraceDebuggerRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfdlSchema {
    public static final String WORKING_DIRECTORY = ".smooks/dfdl-cartridge/";
    protected static final Logger LOGGER = LoggerFactory.getLogger(DfdlSchema.class);
    protected final URI uri;
    protected final Map<String, String> variables;
    protected final ValidationMode validationMode;
    protected final boolean cacheOnDisk;
    protected final boolean debugging;
    protected final String distinguishedRootNode;

    public DfdlSchema(URI uri, Map<String, String> variables, ValidationMode validationMode, boolean cacheOnDisk, boolean debugging, String distinguishedRootNode) {
        this.uri = uri;
        this.variables = variables;
        this.validationMode = validationMode;
        this.cacheOnDisk = cacheOnDisk;
        this.debugging = debugging;
        this.distinguishedRootNode = distinguishedRootNode;
    }

    public URI getUri() {
        return this.uri;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public boolean isCacheOnDisk() {
        return this.cacheOnDisk;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public String getName() {
        return this.uri + ":" + this.validationMode + ":" + this.cacheOnDisk + ":" + this.debugging + ":" + this.variables.toString();
    }

    public DataProcessor compile() throws Throwable {
        DataProcessor dataProcessor;
        if (this.cacheOnDisk) {
            File binSchemaFile = new File(WORKING_DIRECTORY + new File(this.uri.getPath()).getName() + ".dat");
            binSchemaFile.getParentFile().mkdirs();
            if (binSchemaFile.exists()) {
                LOGGER.info("Loading compiled DFDL schema from {}", (Object)binSchemaFile.getAbsolutePath());
                dataProcessor = Daffodil.compiler().reload(binSchemaFile);
            } else {
                dataProcessor = this.compileSource();
                LOGGER.info("Saving compiled DFDL schema to {}", (Object)binSchemaFile.getAbsolutePath());
                dataProcessor.save(Channels.newChannel(new FileOutputStream(binSchemaFile)));
            }
        } else {
            dataProcessor = this.compileSource();
        }
        if (this.debugging) {
            dataProcessor = dataProcessor.withDebuggerRunner((DebuggerRunner)new TraceDebuggerRunner()).withDebugging(true);
        }
        return dataProcessor.withValidationMode(this.validationMode).withExternalVariables(new HashMap<String, String>(this.variables));
    }

    protected DataProcessor compileSource() throws Throwable {
        List diagnostics;
        Iterator iterator;
        ProcessorFactory processorFactory;
        Compiler compiler = Daffodil.compiler();
        if (this.distinguishedRootNode != null) {
            compiler.setDistinguishedRootNode(this.distinguishedRootNode.substring(this.distinguishedRootNode.indexOf("}") + 1), this.distinguishedRootNode.substring(this.distinguishedRootNode.indexOf("{") + 1, this.distinguishedRootNode.indexOf("}")));
        }
        if ((processorFactory = compiler.compileSource(this.uri)).isError()) {
            List diagnostics2 = processorFactory.getDiagnostics();
            throw ((Diagnostic)diagnostics2.get(0)).getSomeCause();
        }
        DataProcessor dataProcessor = processorFactory.onPath("/");
        if (dataProcessor.isError() && (iterator = (diagnostics = dataProcessor.getDiagnostics()).iterator()).hasNext()) {
            Diagnostic diagnostic = (Diagnostic)iterator.next();
            throw diagnostic.getSomeCause();
        }
        return dataProcessor;
    }
}

