/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.dfdl.parser;

import org.apache.daffodil.infoset.DIArray;
import org.apache.daffodil.infoset.DIComplex;
import org.apache.daffodil.infoset.DIElement;
import org.apache.daffodil.infoset.DISimple;
import org.apache.daffodil.japi.infoset.InfosetOutputter;
import org.smooks.api.SmooksException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import scala.Option;
import scala.xml.NamespaceBinding;
import scala.xml.TopScope$;

class ContentHandlerInfosetOutputter
extends InfosetOutputter {
    protected static final char[] INDENT = "\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t".toCharArray();
    protected final ContentHandler contentHandler;
    protected final boolean indent;
    protected int elementLevel = 0;

    ContentHandlerInfosetOutputter(ContentHandler contentHandler, boolean indent) {
        this.contentHandler = contentHandler;
        this.indent = indent;
    }

    public void reset() {
    }

    public void startDocument() {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    public void endDocument() {
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    public void startSimple(DISimple diSimple) {
        try {
            AttributesImpl attributes = this.createAttributes((DIElement)diSimple);
            if (this.isNilled((DIElement)diSimple)) {
                attributes.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi:nil", "NMTOKEN", "true");
            }
            this.indent(this.elementLevel);
            this.contentHandler.startElement(this.getNamespaceUri((DIElement)diSimple), diSimple.erd().name(), this.getQName((DIElement)diSimple), attributes);
            if (!this.isNilled((DIElement)diSimple) && diSimple.hasValue()) {
                this.contentHandler.characters(diSimple.dataValueAsString().toCharArray(), 0, diSimple.dataValueAsString().length());
            }
        }
        catch (Exception e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    public void endSimple(DISimple diSimple) {
        try {
            this.contentHandler.endElement(this.getNamespaceUri((DIElement)diSimple), diSimple.erd().name(), this.getQName((DIElement)diSimple));
        }
        catch (Exception e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    public void startComplex(DIComplex diComplex) {
        try {
            this.indent(this.elementLevel);
            String nsUri = this.getNamespaceUri((DIElement)diComplex);
            this.contentHandler.startElement(nsUri, diComplex.erd().name(), this.getQName((DIElement)diComplex), this.createAttributes((DIElement)diComplex));
            ++this.elementLevel;
            if (diComplex.isEmpty()) {
                --this.elementLevel;
                this.contentHandler.endElement(nsUri, diComplex.erd().name(), this.getQName((DIElement)diComplex));
            }
        }
        catch (SAXException e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    protected AttributesImpl createAttributes(DIElement diElement) {
        AttributesImpl attributes = new AttributesImpl();
        if (diElement.erd().namedQName().prefix().isDefined()) {
            TopScope$ nsbEnd;
            NamespaceBinding nsbStart = diElement.erd().minimizedScope();
            Object object = nsbEnd = diElement.isRoot() ? TopScope$.MODULE$ : diElement.diParent().erd().minimizedScope();
            if (nsbStart != nsbEnd) {
                for (NamespaceBinding namespaceBinding = nsbStart; namespaceBinding != TopScope$.MODULE$; namespaceBinding = namespaceBinding.copy$default$3()) {
                    attributes.addAttribute("http://www.w3.org/2000/xmlns/", namespaceBinding.prefix(), "xmlns:" + namespaceBinding.prefix(), "CDATA", namespaceBinding.uri());
                }
            }
        }
        return attributes;
    }

    public void endComplex(DIComplex diComplex) {
        try {
            --this.elementLevel;
            this.indent(this.elementLevel);
            this.contentHandler.endElement(diComplex.erd().targetNamespace().toString(), diComplex.erd().name(), this.getQName((DIElement)diComplex));
        }
        catch (SAXException e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    public void startArray(DIArray diArray) {
    }

    public void endArray(DIArray diArray) {
    }

    protected String getQName(DIElement diElement) {
        Option prefix = diElement.erd().namedQName().prefix();
        return prefix.isEmpty() || ((String)prefix.get()).equals("") ? "" : (String)prefix.get() + ":" + diElement.erd().name();
    }

    protected void indent(int elementLevel) throws SAXException {
        if (this.indent) {
            this.contentHandler.characters(INDENT, 0, elementLevel + 1);
        }
    }

    protected String getNamespaceUri(DIElement diElement) {
        return diElement.erd().namedQName().namespace().isNoNamespace() ? "" : diElement.erd().namedQName().namespace().toString();
    }
}

