/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.dfdl.parser;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.Diagnostic;
import org.apache.daffodil.japi.ExternalVariableException;
import org.apache.daffodil.japi.ParseResult;
import org.apache.daffodil.japi.ValidationMode;
import org.apache.daffodil.japi.infoset.InfosetOutputter;
import org.apache.daffodil.japi.io.InputSourceDataInputStream;
import org.apache.daffodil.runtime1.processors.parsers.ParseError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.reader.SmooksXMLReader;
import org.smooks.cartridges.dfdl.DataProcessorFactory;
import org.smooks.cartridges.dfdl.parser.ContentHandlerInfosetOutputter;
import org.smooks.cartridges.dfdl.parser.ParserDfdlSmooksException;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DfdlParser
implements SmooksXMLReader {
    public static final TypedKey<List<Diagnostic>> DIAGNOSTICS_TYPED_KEY = TypedKey.of();
    private static final Logger LOGGER = LoggerFactory.getLogger(DfdlParser.class);
    protected DataProcessor dataProcessor;
    @Inject
    protected ApplicationContext applicationContext;
    @Inject
    protected ResourceConfig resourceConfig;
    @Inject
    @Named(value="dataProcessorFactory")
    protected Class<? extends DataProcessorFactory> dataProcessorFactoryClass;
    @Inject
    @Named(value="schemaUri")
    protected String schemaUri;
    @Inject
    @Named(value="validationMode")
    protected ValidationMode validationMode = ValidationMode.Off;
    @Inject
    protected Boolean indent = false;
    protected ContentHandler contentHandler;
    protected ErrorHandler errorHandler;
    protected DTDHandler dtdHandler;
    protected ExecutionContext executionContext;

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setProperty(String name, Object value) {
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @PostConstruct
    public void postConstruct() throws IllegalAccessException, InstantiationException {
        DataProcessorFactory dataProcessorFactory = this.dataProcessorFactoryClass.newInstance();
        ((LifecycleManager)this.applicationContext.getRegistry().lookup((Function)new LifecycleManagerLookup())).applyPhase((Object)dataProcessorFactory, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.applicationContext.getRegistry(), this.resourceConfig, (Object)dataProcessorFactory)));
        this.dataProcessor = dataProcessorFactory.createDataProcessor();
    }

    protected AbstractMap<String, String> getVariables() {
        List variablesParameters = this.resourceConfig.getParameters("variables");
        HashMap<String, String> variables = new HashMap<String, String>();
        if (variablesParameters != null) {
            for (Parameter variablesParameter : variablesParameters) {
                Map.Entry variable = (Map.Entry)variablesParameter.getValue();
                ((AbstractMap)variables).put((String)variable.getKey(), (String)variable.getValue());
            }
        }
        return variables;
    }

    public void parse(InputSource input) {
        DataProcessor copyDataProcessor;
        InputStream inputStream = input.getByteStream();
        if (inputStream == null) {
            try {
                inputStream = ((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(input.getCharacterStream())).get();
            }
            catch (IOException e) {
                throw new ParserDfdlSmooksException(e);
            }
        }
        InputSourceDataInputStream inputSourceDataInputStream = new InputSourceDataInputStream(inputStream);
        try {
            copyDataProcessor = this.dataProcessor.withExternalVariables(this.getVariables());
        }
        catch (ExternalVariableException e) {
            throw new ParserDfdlSmooksException(e);
        }
        ParseResult parseResult = null;
        while (parseResult == null || inputSourceDataInputStream.hasData()) {
            ContentHandlerInfosetOutputter contentHandlerInfosetOutputter = new ContentHandlerInfosetOutputter(this.contentHandler, this.indent);
            parseResult = copyDataProcessor.parse(inputSourceDataInputStream, (InfosetOutputter)contentHandlerInfosetOutputter);
            if (parseResult.isError()) {
                if (contentHandlerInfosetOutputter.getContentHandlerThrowable() != null) {
                    throw new SmooksException(contentHandlerInfosetOutputter.getContentHandlerThrowable());
                }
                this.executionContext.put(DIAGNOSTICS_TYPED_KEY, (Object)parseResult.getDiagnostics());
                for (Diagnostic diagnostic : parseResult.getDiagnostics()) {
                    if (diagnostic.isError()) {
                        if (this.validationMode.equals((Object)ValidationMode.Full) || diagnostic.getSomeCause() != null && diagnostic.getSomeCause() instanceof ParseError) {
                            throw new ParserDfdlSmooksException(diagnostic.getSomeMessage(), diagnostic.getSomeCause());
                        }
                        LOGGER.error(diagnostic.getSomeMessage());
                        continue;
                    }
                    LOGGER.debug(diagnostic.getSomeMessage());
                }
                continue;
            }
            for (Diagnostic diagnostic : parseResult.getDiagnostics()) {
                LOGGER.debug(diagnostic.getSomeMessage());
            }
        }
    }

    public void parse(String systemId) {
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setIndent(Boolean indent) {
        this.indent = indent;
    }

    public Class<? extends DataProcessorFactory> getDataProcessorFactoryClass() {
        return this.dataProcessorFactoryClass;
    }

    public void setDataProcessorFactoryClass(Class<? extends DataProcessorFactory> dataProcessorFactoryClass) {
        this.dataProcessorFactoryClass = dataProcessorFactoryClass;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    public String getSchemaUri() {
        return this.schemaUri;
    }

    public void setSchemaUri(String schemaUri) {
        this.schemaUri = schemaUri;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }
}

