/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.fixedlength;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.Registry;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.VisitorAppender;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.resource.reader.SmooksXMLReader;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.cartridges.fixedlength.FixedLengthBindingType;
import org.smooks.cartridges.flatfile.function.StringFunctionExecutor;
import org.smooks.cartridges.javabean.Bean;
import org.smooks.engine.delivery.DefaultContentHandlerBinding;
import org.smooks.engine.expression.MVELExpressionEvaluator;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class FixedLengthReader
implements SmooksXMLReader,
VisitorAppender {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedLengthReader.class);
    private static final AttributesImpl EMPTY_ATTRIBS = new AttributesImpl();
    private static final String IGNORE_FIELD = "$ignore$";
    private static final char FUNCTION_SEPARATOR = '?';
    private static char[] INDENT_LF = new char[]{'\n'};
    private static char[] INDENT_1 = new char[]{'\t'};
    private static char[] INDENT_2 = new char[]{'\t', '\t'};
    private ContentHandler contentHandler;
    private ExecutionContext execContext;
    @Inject
    @Named(value="fields")
    private String[] flFields;
    private Field[] fields;
    private int totalFieldLenght;
    @Inject
    private Boolean lineNumber = false;
    @Inject
    private Integer skipLines = 0;
    @Inject
    private Boolean strict = true;
    @Inject
    private Charset encoding = StandardCharsets.UTF_8;
    @Inject
    private String rootElementName = "set";
    @Inject
    private String recordElementName = "record";
    @Inject
    private String lineNumberAttributeName = "number";
    @Inject
    private String truncatedAttributeName = "truncated";
    @Inject
    private Boolean indent = false;
    @Inject
    private Optional<String> bindBeanId;
    @Inject
    private Optional<Class<?>> bindBeanClass;
    @Inject
    private Optional<FixedLengthBindingType> bindingType;
    @Inject
    private Optional<String> bindMapKeyField;
    @Inject
    private Registry registry;
    private static final String RECORD_BEAN = "flRecordBean";
    public boolean initialized = false;

    public List<ContentHandlerBinding<Visitor>> addVisitors() {
        ArrayList<ContentHandlerBinding<Visitor>> visitorBindings = new ArrayList<ContentHandlerBinding<Visitor>>();
        this.initialize();
        if (this.bindBeanId.isPresent() && this.bindBeanClass.isPresent()) {
            if (this.bindingType.get().equals((Object)FixedLengthBindingType.LIST)) {
                Bean listBean = new Bean(ArrayList.class, this.bindBeanId.get(), "#document");
                listBean.setRegistry(this.registry);
                Bean bean = listBean.newBean(this.bindBeanClass.get(), this.recordElementName);
                listBean.bindTo(bean);
                this.addFieldBindings(bean);
                visitorBindings.addAll(listBean.addVisitors());
            } else if (this.bindingType.get().equals((Object)FixedLengthBindingType.MAP)) {
                if (!this.bindMapKeyField.isPresent()) {
                    throw new SmooksConfigException("FixedLength 'MAP' Binding must specify a 'keyField' property on the binding configuration.");
                }
                this.assertValidFieldName(this.bindMapKeyField.get());
                Bean mapBean = new Bean(LinkedHashMap.class, this.bindBeanId.get(), "#document");
                mapBean.setRegistry(this.registry);
                Bean recordBean = new Bean(this.bindBeanClass.get(), RECORD_BEAN, this.recordElementName);
                recordBean.setRegistry(this.registry);
                MapBindingWiringVisitor wiringVisitor = new MapBindingWiringVisitor(this.bindMapKeyField.get(), this.bindBeanId.get());
                this.addFieldBindings(recordBean);
                visitorBindings.addAll(mapBean.addVisitors());
                visitorBindings.addAll(recordBean.addVisitors());
                visitorBindings.add((ContentHandlerBinding<Visitor>)new DefaultContentHandlerBinding((org.smooks.api.delivery.ContentHandler)wiringVisitor, this.recordElementName, null, this.registry));
            } else {
                Bean bean = new Bean(this.bindBeanClass.get(), this.bindBeanId.get(), this.recordElementName);
                bean.setRegistry(this.registry);
                this.addFieldBindings(bean);
                visitorBindings.addAll(bean.addVisitors());
            }
        }
        return visitorBindings;
    }

    private void addFieldBindings(Bean bean) {
        for (Field field1 : this.fields) {
            String field = field1.getName();
            if (field.equals(IGNORE_FIELD)) continue;
            bean.bindTo(field, this.recordElementName + "/" + field);
        }
    }

    public void setExecutionContext(ExecutionContext request) {
        this.execContext = request;
    }

    @PostConstruct
    public void initialize() {
        this.buildFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource flInputSource) throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse Fixed Length stream.");
        }
        if (this.execContext == null) {
            throw new IllegalStateException("'execContext' not set.  Cannot parse Fixed Length stream.");
        }
        try {
            String flRecord;
            int lineNumber = 0;
            Reader flStreamReader = flInputSource.getCharacterStream();
            if (flStreamReader == null) {
                flStreamReader = new InputStreamReader(flInputSource.getByteStream(), this.encoding);
            }
            BufferedReader flLineReader = new BufferedReader(flStreamReader);
            this.contentHandler.startDocument();
            this.contentHandler.startElement("", this.rootElementName, "", EMPTY_ATTRIBS);
            while ((flRecord = flLineReader.readLine()) != null) {
                boolean invalidLength;
                if (++lineNumber <= this.skipLines) continue;
                boolean bl = invalidLength = flRecord.length() < this.totalFieldLenght;
                if (invalidLength && this.strict.booleanValue()) {
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.debug("[WARNING-FIXEDLENGTH] Fixed Length line #" + lineNumber + " is invalid.  The line doesn't contain enough characters to fill all the fields. This line is skipped.");
                    continue;
                }
                char[] recordChars = flRecord.toCharArray();
                if (this.indent.booleanValue()) {
                    this.contentHandler.characters(INDENT_LF, 0, 1);
                    this.contentHandler.characters(INDENT_1, 0, 1);
                }
                AttributesImpl attrs = EMPTY_ATTRIBS;
                if (this.lineNumber.booleanValue() || invalidLength) {
                    attrs = new AttributesImpl();
                    if (this.lineNumber.booleanValue()) {
                        attrs.addAttribute("", this.lineNumberAttributeName, this.lineNumberAttributeName, "xs:int", Integer.toString(lineNumber));
                    }
                    if (invalidLength) {
                        attrs.addAttribute("", this.truncatedAttributeName, this.truncatedAttributeName, "xs:boolean", Boolean.TRUE.toString());
                    }
                }
                this.contentHandler.startElement("", this.recordElementName, "", attrs);
                int fieldLengthTotal = 0;
                for (int i = 0; i < this.flFields.length; ++i) {
                    String fieldName = this.fields[i].getName();
                    int fieldLength = this.fields[i].getLength();
                    StringFunctionExecutor stringFunctionExecutor = this.fields[i].getStringFunctionExecutor();
                    if (!this.fields[i].ignore()) {
                        if (this.indent.booleanValue()) {
                            this.contentHandler.characters(INDENT_LF, 0, 1);
                            this.contentHandler.characters(INDENT_2, 0, 2);
                        }
                        boolean truncated = fieldLengthTotal + fieldLength > flRecord.length();
                        AttributesImpl recordAttrs = EMPTY_ATTRIBS;
                        if (truncated) {
                            recordAttrs = new AttributesImpl();
                            recordAttrs.addAttribute("", this.truncatedAttributeName, this.truncatedAttributeName, "xs:boolean", Boolean.TRUE.toString());
                        }
                        this.contentHandler.startElement("", fieldName, "", recordAttrs);
                        if (!truncated) {
                            if (stringFunctionExecutor == null) {
                                this.contentHandler.characters(recordChars, fieldLengthTotal, fieldLength);
                            } else {
                                String value = flRecord.substring(fieldLengthTotal, fieldLengthTotal + fieldLength);
                                value = stringFunctionExecutor.execute(value);
                                this.contentHandler.characters(value.toCharArray(), 0, value.length());
                            }
                        }
                        this.contentHandler.endElement("", fieldName, "");
                    }
                    fieldLengthTotal += fieldLength;
                }
                if (this.indent.booleanValue()) {
                    this.contentHandler.characters(INDENT_LF, 0, 1);
                    this.contentHandler.characters(INDENT_1, 0, 1);
                }
                this.contentHandler.endElement(null, this.recordElementName, "");
            }
            if (this.indent.booleanValue()) {
                this.contentHandler.characters(INDENT_LF, 0, 1);
            }
            this.contentHandler.endElement("", this.rootElementName, "");
            this.contentHandler.endDocument();
        }
        finally {
            this.contentHandler = null;
            this.execContext = null;
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    private void assertValidFieldName(String fieldName) {
        for (Field field : this.fields) {
            if (!field.getName().equals(fieldName)) continue;
            return;
        }
        String fieldNames = "";
        for (Field field : this.fields) {
            if (field.ignore()) continue;
            if (fieldNames.length() > 0) {
                fieldNames = fieldNames + ", ";
            }
            fieldNames = fieldNames + field.getName();
        }
        throw new SmooksConfigException("Invalid field name '" + fieldName + "'.  Valid names: [" + fieldNames + "].");
    }

    private void buildFields() {
        Field[] fields = new Field[this.flFields.length];
        int totalFieldLenght = 0;
        for (int i = 0; i < this.flFields.length; ++i) {
            String fieldInfos = this.flFields[i].trim();
            String fieldName = fieldInfos.substring(0, fieldInfos.lastIndexOf(91));
            int fieldLength = Integer.parseInt(fieldInfos.substring(fieldInfos.lastIndexOf(91) + 1, fieldInfos.lastIndexOf(93)));
            String functionDefinition = fieldInfos.substring(fieldInfos.lastIndexOf(93) + 1);
            if (functionDefinition.length() != 0 && functionDefinition.charAt(0) == '?') {
                functionDefinition = functionDefinition.substring(1);
            }
            StringFunctionExecutor stringFunctionExecutor = null;
            if (functionDefinition.length() != 0) {
                stringFunctionExecutor = StringFunctionExecutor.getInstance((String)functionDefinition);
            }
            fields[i] = new Field(fieldName, fieldLength, stringFunctionExecutor);
            totalFieldLenght += fieldLength;
        }
        this.fields = fields;
        this.totalFieldLenght = totalFieldLenght;
    }

    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supported by this reader.");
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler arg0) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    private static class MapBindingWiringVisitor
    implements AfterVisitor,
    Consumer {
        private final MVELExpressionEvaluator keyExtractor = new MVELExpressionEvaluator();
        private final String mapBindingKey;

        private MapBindingWiringVisitor(String bindKeyField, String mapBindingKey) {
            this.keyExtractor.setExpression("flRecordBean." + bindKeyField);
            this.mapBindingKey = mapBindingKey;
        }

        public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
            this.wireObject(executionContext);
        }

        private void wireObject(ExecutionContext executionContext) {
            BeanContext beanContext = executionContext.getBeanContext();
            Map beanMap = beanContext.getBeanMap();
            Object key = this.keyExtractor.getValue((Object)beanMap);
            Map map = (Map)beanContext.getBean(this.mapBindingKey);
            Object record = beanContext.getBean(FixedLengthReader.RECORD_BEAN);
            map.put(key, record);
        }

        public boolean consumes(Object object) {
            return this.keyExtractor.getExpression().indexOf(object.toString()) != -1;
        }
    }

    private class Field {
        private final String name;
        private final int length;
        private final boolean ignore;
        private final StringFunctionExecutor stringFunctionExecutor;

        public Field(String name, int length, StringFunctionExecutor stringFunctionExecutor) {
            this.name = name;
            this.length = length;
            this.stringFunctionExecutor = stringFunctionExecutor;
            this.ignore = FixedLengthReader.IGNORE_FIELD.equals(name);
        }

        public String getName() {
            return this.name;
        }

        public int getLength() {
            return this.length;
        }

        public boolean ignore() {
            return this.ignore;
        }

        public StringFunctionExecutor getStringFunctionExecutor() {
            return this.stringFunctionExecutor;
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("name", (Object)this.name).append("length", this.length).append("stringFunctionExecutor", (Object)this.stringFunctionExecutor);
            return builder.toString();
        }
    }
}

