/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.fixedlength.prog;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.UUID;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.smooks.Smooks;
import org.smooks.api.resource.config.ReaderConfigurator;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.fixedlength.FixedLengthBinding;
import org.smooks.cartridges.fixedlength.FixedLengthBindingType;
import org.smooks.cartridges.fixedlength.FixedLengthReaderConfigurator;
import org.smooks.io.payload.JavaResult;

public class FixedLengthMapBinder {
    private String beanId = UUID.randomUUID().toString();
    private Smooks smooks;

    public FixedLengthMapBinder(String fields, Class recordType, String keyField) {
        AssertArgument.isNotNullAndNotEmpty((String)fields, (String)"fields");
        AssertArgument.isNotNull((Object)recordType, (String)"recordType");
        AssertArgument.isNotNullAndNotEmpty((String)keyField, (String)"keyField");
        this.smooks = new Smooks();
        this.smooks.setReaderConfig((ReaderConfigurator)new FixedLengthReaderConfigurator(fields).setBinding(new FixedLengthBinding(this.beanId, recordType, FixedLengthBindingType.MAP).setKeyField(keyField)));
    }

    public Map bind(Reader fixedLengthStream) {
        AssertArgument.isNotNull((Object)fixedLengthStream, (String)"fixedLengthStream");
        JavaResult javaResult = new JavaResult();
        this.smooks.filterSource((Source)new StreamSource(fixedLengthStream), new Result[]{javaResult});
        return (Map)javaResult.getBean(this.beanId);
    }

    public Map bind(InputStream fixedLengthStream) {
        return this.bind(new InputStreamReader(fixedLengthStream));
    }
}

