/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.flatfile.variablefield;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.smooks.api.ExecutionContext;
import org.smooks.api.Registry;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.VisitorAppender;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.cartridges.flatfile.BindingType;
import org.smooks.cartridges.flatfile.FieldMetaData;
import org.smooks.cartridges.flatfile.RecordMetaData;
import org.smooks.cartridges.flatfile.RecordParserFactory;
import org.smooks.cartridges.flatfile.variablefield.VariableFieldRecordMetaData;
import org.smooks.cartridges.javabean.Bean;
import org.smooks.engine.delivery.DefaultContentHandlerBinding;
import org.smooks.engine.expression.MVELExpressionEvaluator;
import org.smooks.support.XmlUtil;
import org.w3c.dom.Element;

public abstract class VariableFieldRecordParserFactory
implements RecordParserFactory,
VisitorAppender {
    private static final String RECORD_BEAN = "recordBean";
    @Inject
    private Optional<String> fields;
    private VariableFieldRecordMetaData vfRecordMetaData;
    @Inject
    private Optional<String> recordDelimiter;
    private Pattern recordDelimiterPattern;
    @Inject
    private Boolean keepDelimiter = false;
    @Inject
    private String recordElementName = "record";
    @Inject
    private Optional<String> bindBeanId;
    @Inject
    private Optional<Class<?>> bindBeanClass;
    @Inject
    private Optional<BindingType> bindingType;
    @Inject
    private Optional<String> bindMapKeyField;
    @Inject
    @Named(value="skip-line-count")
    private Integer skipLines = 0;
    @Inject
    @Named(value="fields-in-message")
    private Boolean fieldsInMessage = false;
    @Inject
    private Boolean validateHeader = false;
    @Inject
    private Boolean strict = false;
    @Inject
    private Registry registry;
    private String overFlowFromLastRecord = "";

    public int getSkipLines() {
        if (this.skipLines < 0) {
            return 0;
        }
        return this.skipLines;
    }

    public boolean fieldsInMessage() {
        return this.fieldsInMessage;
    }

    public boolean validateHeader() {
        return this.validateHeader;
    }

    public String getRecordElementName() {
        return this.recordElementName;
    }

    public RecordMetaData getRecordMetaData() {
        return this.vfRecordMetaData.getRecordMetaData();
    }

    public RecordMetaData getRecordMetaData(List<String> fieldValues) {
        return this.vfRecordMetaData.getRecordMetaData(fieldValues);
    }

    public boolean isMultiTypeRecordSet() {
        return this.vfRecordMetaData.isMultiTypeRecordSet();
    }

    public boolean strict() {
        return this.strict;
    }

    public List<ContentHandlerBinding<Visitor>> addVisitors() {
        ArrayList<ContentHandlerBinding<Visitor>> visitorBindings = new ArrayList<ContentHandlerBinding<Visitor>>();
        if (this.bindBeanId.isPresent() && this.bindBeanClass.isPresent()) {
            if (this.fieldsInMessage.booleanValue()) {
                throw new SmooksConfigException("Unsupported reader based bean binding config.  Not supported when fields are defined in message.  See 'fieldsInMessage' attribute.");
            }
            if (this.vfRecordMetaData.isMultiTypeRecordSet()) {
                throw new SmooksConfigException("Unsupported reader based bean binding config for a multi record type record set.  Only supported for single record type record sets.  Use <jb:bean> configs for multi binding record type record sets.");
            }
            if (BindingType.LIST.equals(this.bindingType.orElse(null))) {
                Bean listBean = new Bean(ArrayList.class, this.bindBeanId.get(), "#document", this.registry);
                Bean bean = listBean.newBean(this.bindBeanClass.get(), this.recordElementName);
                listBean.bindTo(bean);
                this.addFieldBindings(bean);
                visitorBindings.addAll(listBean.addVisitors());
            } else if (BindingType.MAP.equals(this.bindingType.orElse(null))) {
                if (!this.bindMapKeyField.isPresent()) {
                    throw new SmooksConfigException("'MAP' Binding must specify a 'keyField' property on the binding configuration.");
                }
                this.vfRecordMetaData.getRecordMetaData().assertValidFieldName(this.bindMapKeyField.get());
                Bean mapBean = new Bean(LinkedHashMap.class, this.bindBeanId.get(), "#document", this.registry);
                Bean recordBean = new Bean(this.bindBeanClass.get(), RECORD_BEAN, this.recordElementName, this.registry);
                this.addFieldBindings(recordBean);
                visitorBindings.addAll(mapBean.addVisitors());
                visitorBindings.addAll(recordBean.addVisitors());
                MapBindingWiringVisitor wiringVisitor = new MapBindingWiringVisitor(this.bindMapKeyField.get(), this.bindBeanId.get());
                visitorBindings.add((ContentHandlerBinding<Visitor>)new DefaultContentHandlerBinding((ContentHandler)wiringVisitor, this.recordElementName, null, this.registry));
            } else {
                Bean bean = new Bean(this.bindBeanClass.get(), this.bindBeanId.get(), this.recordElementName, this.registry);
                this.addFieldBindings(bean);
                visitorBindings.addAll(bean.addVisitors());
            }
        }
        return visitorBindings;
    }

    @PostConstruct
    public final void fixupRecordDelimiter() {
        if (!this.recordDelimiter.isPresent()) {
            return;
        }
        if (this.recordDelimiter.get().startsWith("regex:")) {
            this.recordDelimiterPattern = Pattern.compile(this.recordDelimiter.get().substring("regex:".length()), 40);
        } else {
            this.recordDelimiter = Optional.of(VariableFieldRecordParserFactory.removeSpecialCharEncodeString(this.recordDelimiter.get(), "\\n", '\n'));
            this.recordDelimiter = Optional.of(VariableFieldRecordParserFactory.removeSpecialCharEncodeString(this.recordDelimiter.get(), "\\r", '\r'));
            this.recordDelimiter = Optional.of(VariableFieldRecordParserFactory.removeSpecialCharEncodeString(this.recordDelimiter.get(), "\\t", '\t'));
            this.recordDelimiter = Optional.ofNullable(XmlUtil.removeEntities((String)this.recordDelimiter.get()));
        }
    }

    @PostConstruct
    public final void buildRecordMetaData() {
        this.vfRecordMetaData = new VariableFieldRecordMetaData(this.recordElementName, this.fields.orElse(null));
    }

    public void readRecord(Reader recordReader, StringBuilder recordBuffer, int recordNumber) throws IOException {
        int c;
        recordBuffer.setLength(0);
        recordBuffer.append(this.overFlowFromLastRecord);
        RecordBoundaryLocator boundaryLocator = this.recordDelimiterPattern != null ? new RegexRecordBoundaryLocator(recordBuffer, recordNumber) : new SimpleRecordBoundaryLocator(recordBuffer, recordNumber);
        while ((c = recordReader.read()) != -1) {
            if (recordBuffer.length() == 0 && (c == 10 || c == 13)) continue;
            recordBuffer.append((char)c);
            if (!boundaryLocator.atEndOfRecord()) continue;
        }
        this.overFlowFromLastRecord = boundaryLocator.getOverflowCharacters();
    }

    private void addFieldBindings(Bean bean) {
        for (FieldMetaData fieldMetaData : this.vfRecordMetaData.getRecordMetaData().getFields()) {
            if (fieldMetaData.ignore()) continue;
            bean.bindTo(fieldMetaData.getName(), this.recordElementName + "/" + fieldMetaData.getName());
        }
    }

    private static String removeSpecialCharEncodeString(String string, String encodedString, char replaceChar) {
        return string.replace(encodedString, new String(new char[]{replaceChar}));
    }

    private abstract class RecordBoundaryLocator {
        protected StringBuilder recordBuffer;
        protected int recordNumber;

        protected RecordBoundaryLocator(StringBuilder recordBuffer, int recordNumber) {
            this.recordBuffer = recordBuffer;
            this.recordNumber = recordNumber;
        }

        abstract boolean atEndOfRecord();

        abstract String getOverflowCharacters();
    }

    private class RegexRecordBoundaryLocator
    extends RecordBoundaryLocator {
        private int startFindIndex;
        private int endRecordIndex;
        private String overFlow;

        protected RegexRecordBoundaryLocator(StringBuilder recordBuffer, int recordNumber) {
            super(recordBuffer, recordNumber);
            this.overFlow = "";
            this.startFindIndex = recordBuffer.length();
        }

        @Override
        boolean atEndOfRecord() {
            Matcher matcher = VariableFieldRecordParserFactory.this.recordDelimiterPattern.matcher(this.recordBuffer);
            if (matcher.find(this.startFindIndex)) {
                if (this.recordNumber == 1 && this.startFindIndex == 0) {
                    this.startFindIndex = matcher.end();
                    return false;
                }
                this.endRecordIndex = matcher.start();
                this.overFlow = this.recordBuffer.substring(this.endRecordIndex);
                this.recordBuffer.setLength(this.endRecordIndex);
                return true;
            }
            return false;
        }

        @Override
        String getOverflowCharacters() {
            return this.overFlow;
        }
    }

    private class SimpleRecordBoundaryLocator
    extends RecordBoundaryLocator {
        private SimpleRecordBoundaryLocator(StringBuilder recordBuffer, int recordNumber) {
            super(recordBuffer, recordNumber);
        }

        @Override
        boolean atEndOfRecord() {
            int builderLen = this.recordBuffer.length();
            char lastChar = this.recordBuffer.charAt(builderLen - 1);
            if (VariableFieldRecordParserFactory.this.recordDelimiter.isPresent()) {
                int stringLen = ((String)VariableFieldRecordParserFactory.this.recordDelimiter.get()).length();
                if (builderLen < stringLen) {
                    return false;
                }
                int stringIndx = 0;
                for (int i = builderLen - stringLen; i < builderLen; ++i) {
                    if (this.recordBuffer.charAt(i) != ((String)VariableFieldRecordParserFactory.this.recordDelimiter.get()).charAt(stringIndx)) {
                        return false;
                    }
                    ++stringIndx;
                }
                if (!VariableFieldRecordParserFactory.this.keepDelimiter.booleanValue()) {
                    this.recordBuffer.setLength(builderLen - stringLen);
                }
                return true;
            }
            if (lastChar == '\r' || lastChar == '\n') {
                if (!VariableFieldRecordParserFactory.this.keepDelimiter.booleanValue()) {
                    this.recordBuffer.setLength(builderLen - 1);
                }
                return true;
            }
            return false;
        }

        @Override
        String getOverflowCharacters() {
            return "";
        }
    }

    private class MapBindingWiringVisitor
    implements AfterVisitor,
    Consumer {
        private MVELExpressionEvaluator keyExtractor = new MVELExpressionEvaluator();
        private String mapBindingKey;

        private MapBindingWiringVisitor(String bindKeyField, String mapBindingKey) {
            this.keyExtractor.setExpression("recordBean." + bindKeyField);
            this.mapBindingKey = mapBindingKey;
        }

        public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
            this.wireObject(executionContext);
        }

        private void wireObject(ExecutionContext executionContext) {
            BeanContext beanContext = executionContext.getBeanContext();
            Map beanMap = beanContext.getBeanMap();
            Object key = this.keyExtractor.getValue((Object)beanMap);
            Map map = (Map)beanContext.getBean(this.mapBindingKey);
            Object record = beanContext.getBean(VariableFieldRecordParserFactory.RECORD_BEAN);
            map.put(key, record);
        }

        public boolean consumes(Object object) {
            return this.keyExtractor.getExpression().contains(object.toString());
        }
    }
}

