/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.javabean.BeanInstanceCreator;
import org.smooks.cartridges.javabean.BeanInstancePopulator;
import org.smooks.cartridges.javabean.BeanRuntimeInfo;
import org.smooks.cartridges.javabean.BindingAppender;
import org.smooks.cartridges.javabean.ext.SelectorPropertyResolver;
import org.smooks.cartridges.javabean.factory.Factory;
import org.smooks.engine.converter.TypeConverterFactoryLoader;
import org.smooks.engine.delivery.DefaultContentHandlerBinding;
import org.smooks.engine.lookup.converter.SourceTargetTypeConverterFactoryLookup;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.smooks.support.ClassUtil;

public class Bean
extends BindingAppender {
    private static final Set<TypeConverterFactory<?, ?>> TYPE_CONVERTER_FACTORIES = new TypeConverterFactoryLoader().load();
    BeanInstanceCreator beanInstanceCreator;
    private Class<?> beanClass;
    private String createOnElement;
    private String targetNamespace;
    private List<Binding> bindings = new ArrayList<Binding>();
    private List<Bean> wirings = new ArrayList<Bean>();
    private boolean processed = false;

    public Bean(Class<?> beanClass, String beanId) {
        this(beanClass, beanId, (Factory)null);
    }

    public <T> Bean(Class<T> beanClass, String beanId, Factory<? extends T> factory) {
        this(beanClass, beanId, "#document", null, factory);
    }

    public Bean(Class<?> beanClass, String beanId, String createOnElement) {
        this(beanClass, beanId, createOnElement, (String)null);
    }

    public <T> Bean(Class<T> beanClass, String beanId, String createOnElement, Factory<? extends T> factory) {
        this(beanClass, beanId, createOnElement, null, factory);
    }

    public Bean(Class<?> beanClass, String beanId, String createOnElement, String createOnElementNS) {
        this(beanClass, beanId, createOnElement, createOnElementNS, null);
    }

    public <T> Bean(Class<T> beanClass, String beanId, String createOnElement, String createOnElementNS, Factory<? extends T> factory) {
        super(beanId);
        AssertArgument.isNotNull(beanClass, (String)"beanClass");
        AssertArgument.isNotNull((Object)createOnElement, (String)"createOnElement");
        this.beanClass = beanClass;
        this.createOnElement = createOnElement;
        this.targetNamespace = createOnElementNS;
        this.beanInstanceCreator = new BeanInstanceCreator(beanId, beanClass, factory);
    }

    public static Bean newBean(Class<?> beanClass, String beanId, String createOnElement, String createOnElementNS) {
        return new Bean(beanClass, beanId, createOnElement, createOnElementNS);
    }

    public static <T> Bean newBean(Class<T> beanClass, String beanId, String createOnElement, String createOnElementNS, Factory<T> factory) {
        return new Bean(beanClass, beanId, createOnElement, createOnElementNS, factory);
    }

    public Bean newBean(Class<?> beanClass, String createOnElement) {
        String randomBeanId = UUID.randomUUID().toString();
        return new Bean(beanClass, randomBeanId, createOnElement);
    }

    public <T> Bean newBean(Class<T> beanClass, String createOnElement, Factory<T> factory) {
        String randomBeanId = UUID.randomUUID().toString();
        return new Bean(beanClass, randomBeanId, createOnElement, factory);
    }

    public Bean newBean(Class<?> beanClass, String beanId, String createOnElement) {
        return new Bean(beanClass, beanId, createOnElement);
    }

    public <T> Bean newBean(Class<T> beanClass, String beanId, String createOnElement, Factory<T> factory) {
        return new Bean(beanClass, beanId, createOnElement, factory);
    }

    public Bean bindTo(String bindingMember, String dataSelector) {
        return this.bindTo(bindingMember, dataSelector, null);
    }

    public Bean bindTo(String bindingMember, String dataSelector, TypeConverter<? super String, ?> typeConverter) {
        this.assertNotProcessed();
        AssertArgument.isNotNull((Object)bindingMember, (String)"bindingMember");
        AssertArgument.isNotNull((Object)dataSelector, (String)"dataSelector");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        DefaultResourceConfig populatorConfig = new DefaultResourceConfig(dataSelector);
        SelectorPropertyResolver.resolveSelectorTokens((ResourceConfig)populatorConfig);
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setValueAttributeName((String)populatorConfig.getParameterValue("valueAttributeName", String.class));
        beanInstancePopulator.setValueAttributePrefix((String)populatorConfig.getParameterValue("valueAttributePrefix", String.class));
        Method bindingMethod = Bean.getBindingMethod(bindingMember, this.beanClass);
        if (bindingMethod != null) {
            if (typeConverter == null) {
                Class<?> dataType = bindingMethod.getParameterTypes()[0];
                TypeConverterFactory typeConverterFactory = new SourceTargetTypeConverterFactoryLookup(String.class, dataType).lookup(TYPE_CONVERTER_FACTORIES);
                typeConverter = typeConverterFactory != null ? typeConverterFactory.createTypeConverter() : new SourceTargetTypeConverterFactoryLookup(Object.class, Object.class).lookup(TYPE_CONVERTER_FACTORIES).createTypeConverter();
            }
            if (bindingMethod.getName().equals(bindingMember)) {
                beanInstancePopulator.setSetterMethod(bindingMethod.getName());
            } else {
                beanInstancePopulator.setProperty(bindingMember);
            }
        } else {
            beanInstancePopulator.setProperty(bindingMember);
        }
        beanInstancePopulator.setTypeConverter(typeConverter);
        this.bindings.add(new Binding(populatorConfig.getSelectorPath().getSelector(), beanInstancePopulator, false));
        return this;
    }

    public Bean bindTo(String bindingMember, Bean bean) {
        this.assertNotProcessed();
        AssertArgument.isNotNull((Object)bindingMember, (String)"bindingMember");
        AssertArgument.isNotNull((Object)bean, (String)"bean");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setWireBeanId(bean.getBeanId());
        Method bindingMethod = Bean.getBindingMethod(bindingMember, this.beanClass);
        if (bindingMethod != null) {
            if (bindingMethod.getName().equals(bindingMember)) {
                beanInstancePopulator.setSetterMethod(bindingMethod.getName());
            } else {
                beanInstancePopulator.setProperty(bindingMember);
            }
        } else {
            beanInstancePopulator.setProperty(bindingMember);
        }
        this.bindings.add(new Binding(this.createOnElement, beanInstancePopulator, false));
        this.wirings.add(bean);
        return this;
    }

    public Bean bindTo(Bean bean) throws IllegalArgumentException {
        this.assertNotProcessed();
        AssertArgument.isNotNull((Object)bean, (String)"bean");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setWireBeanId(bean.getBeanId());
        this.bindings.add(new Binding(this.createOnElement, beanInstancePopulator, true));
        this.wirings.add(bean);
        return this;
    }

    public Bean bindTo(String dataSelector) {
        return this.bindTo(dataSelector, (TypeConverter)null);
    }

    public Bean bindTo(String dataSelector, TypeConverter<String, ?> typeConverter) {
        this.assertNotProcessed();
        AssertArgument.isNotNull((Object)dataSelector, (String)"dataSelector");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        DefaultResourceConfig populatorConfig = new DefaultResourceConfig(dataSelector);
        SelectorPropertyResolver.resolveSelectorTokens((ResourceConfig)populatorConfig);
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setValueAttributeName((String)populatorConfig.getParameterValue("valueAttributeName", String.class));
        beanInstancePopulator.setValueAttributePrefix((String)populatorConfig.getParameterValue("valueAttributePrefix", String.class));
        beanInstancePopulator.setTypeConverter(typeConverter);
        this.bindings.add(new Binding(populatorConfig.getSelectorPath().getSelector(), beanInstancePopulator, true));
        return this;
    }

    public List<ContentHandlerBinding<Visitor>> addVisitors() {
        if (this.processed) {
            return Collections.EMPTY_LIST;
        }
        this.processed = true;
        ArrayList<ContentHandlerBinding<Visitor>> visitorBindings = new ArrayList<ContentHandlerBinding<Visitor>>();
        DefaultContentHandlerBinding beanInstanceCreateBinding = new DefaultContentHandlerBinding((ContentHandler)this.beanInstanceCreator, this.createOnElement, this.targetNamespace, this.registry);
        ResourceConfig beanInstanceCreatorSmooksResourceConfiguration = beanInstanceCreateBinding.getResourceConfig();
        beanInstanceCreatorSmooksResourceConfiguration.setParameter("beanId", (Object)this.getBeanId());
        beanInstanceCreatorSmooksResourceConfiguration.setParameter("beanClass", (Object)this.beanClass.getName());
        visitorBindings.add((ContentHandlerBinding<Visitor>)beanInstanceCreateBinding);
        for (Bean bean : this.wirings) {
            bean.setRegistry(this.registry);
            visitorBindings.addAll(bean.addVisitors());
        }
        for (Binding binding : this.bindings) {
            DefaultContentHandlerBinding beanInstancePopulatorBinding = new DefaultContentHandlerBinding((ContentHandler)binding.beanInstancePopulator, binding.selector, this.targetNamespace, this.registry);
            beanInstancePopulatorBinding.getResourceConfig().setParameter("beanId", (Object)this.getBeanId());
            visitorBindings.add((ContentHandlerBinding<Visitor>)beanInstancePopulatorBinding);
            if (!binding.assertTargetIsCollection) continue;
            this.assertBeanClassIsCollection();
        }
        return visitorBindings;
    }

    public static Method getBindingMethod(String bindingMember, Class<?> beanClass) {
        Method[] methods;
        for (Method method : methods = beanClass.getMethods()) {
            if (!method.getName().equals(bindingMember) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        String asPropertySetterMethod = ClassUtil.toSetterName((String)bindingMember);
        for (Method method : methods) {
            if (!method.getName().equals(asPropertySetterMethod) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    private void assertBeanClassIsCollection() {
        BeanRuntimeInfo beanRuntimeInfo = this.beanInstanceCreator.getBeanRuntimeInfo();
        if (beanRuntimeInfo.getClassification() != BeanRuntimeInfo.Classification.COLLECTION_COLLECTION && beanRuntimeInfo.getClassification() != BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
            throw new IllegalArgumentException("Invalid call to a Collection/array Bean.bindTo method for a non Collection/Array target.  Binding target type '" + beanRuntimeInfo.getPopulateType().getName() + "' (beanId '" + this.getBeanId() + "').  Use one of the Bean.bindTo methods that specify a 'bindingMember' argument.");
        }
    }

    private void assertNotProcessed() {
        if (this.processed) {
            throw new IllegalStateException("Unexpected attempt to bindTo Bean instance after the Bean instance has been added to a Smooks instance.");
        }
    }

    private static class Binding {
        private final String selector;
        private final BeanInstancePopulator beanInstancePopulator;
        private final boolean assertTargetIsCollection;

        private Binding(String selector, BeanInstancePopulator beanInstancePopulator, boolean assertTargetIsCollection) {
            this.selector = selector;
            this.beanInstancePopulator = beanInstancePopulator;
            this.assertTargetIsCollection = assertTargetIsCollection;
        }
    }
}

