/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleEvent;
import org.smooks.api.bean.lifecycle.BeanLifecycle;
import org.smooks.api.bean.repository.BeanId;
import org.smooks.api.delivery.event.ContentDeliveryConfigBuilderLifecycleEvent;
import org.smooks.api.delivery.event.ContentDeliveryConfigBuilderLifecycleListener;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.ordering.Producer;
import org.smooks.api.lifecycle.VisitLifecycleCleanable;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.VisitAfterReport;
import org.smooks.api.resource.visitor.VisitBeforeReport;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.javabean.BeanRuntimeInfo;
import org.smooks.cartridges.javabean.BeanUtils;
import org.smooks.cartridges.javabean.binding.model.ModelSet;
import org.smooks.cartridges.javabean.factory.Factory;
import org.smooks.cartridges.javabean.factory.FactoryDefinitionParser;
import org.smooks.engine.bean.lifecycle.DefaultBeanContextLifecycleEvent;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.expression.MVELExpressionEvaluator;
import org.smooks.support.CollectionsUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@VisitBeforeReport(summary="Created <b>${resource.parameters.beanId!'undefined'}</b> bean instance.  Associated lifecycle if wired to another bean.", detailTemplate="reporting/BeanInstanceCreatorReport_Before.html")
@VisitAfterReport(condition="parameters.containsKey('setOn') || parameters.beanClass.value.endsWith('[]')", summary="Ended bean lifecycle. Set bean on any targets.", detailTemplate="reporting/BeanInstanceCreatorReport_After.html")
public class BeanInstanceCreator
implements BeforeVisitor,
AfterVisitor,
ContentDeliveryConfigBuilderLifecycleListener,
Producer,
VisitLifecycleCleanable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanInstanceCreator.class);
    public static final String INIT_VAL_EXPRESSION = "initValExpression";
    private String id;
    @Inject
    @Named(value="beanId")
    private String beanIdName;
    @Inject
    @Named(value="beanClass")
    private Optional<String> beanClassName;
    @Inject
    @Named(value="beanFactory")
    private Optional<String> beanFactoryDefinition;
    @Inject
    private Boolean retain = true;
    @Inject
    private ResourceConfig config;
    @Inject
    private ApplicationContext appContext;
    private BeanRuntimeInfo beanRuntimeInfo;
    private BeanId beanId;
    private MVELExpressionEvaluator initValsExpression;
    private Factory<?> factory;

    public BeanInstanceCreator() {
    }

    public BeanInstanceCreator(String beanId, Class<?> beanClass) {
        this(beanId, beanClass, null);
    }

    public <T> BeanInstanceCreator(String beanId, Class<T> beanClass, Factory<? extends T> factory) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        AssertArgument.isNotNull(beanClass, (String)"beanClass");
        this.beanIdName = beanId;
        this.beanClassName = Optional.of(BeanInstanceCreator.toClassName(beanClass));
        this.factory = factory;
    }

    public String getBeanId() {
        return this.beanIdName;
    }

    public ResourceConfig getConfig() {
        return this.config;
    }

    @PostConstruct
    public void postConstruct() throws SmooksConfigException {
        List initValExpressions;
        this.buildId();
        this.beanId = this.appContext.getBeanIdStore().register(this.beanIdName);
        this.beanId.setCreateResourceConfiguration(this.config);
        if (StringUtils.isNotBlank((String)this.beanFactoryDefinition.orElse(null))) {
            int aliasSplitterIndex;
            String alias = null;
            String definition = this.beanFactoryDefinition.get();
            if (!definition.contains("#")) {
                try {
                    URI definitionURI = new URI(definition);
                    if (definitionURI.getScheme() == null) {
                        definition = "mvel:" + definition;
                    }
                }
                catch (URISyntaxException definitionURI) {
                    // empty catch block
                }
            }
            if ((aliasSplitterIndex = definition.indexOf(58)) > 0) {
                alias = definition.substring(0, aliasSplitterIndex);
                definition = definition.substring(aliasSplitterIndex + 1);
            }
            this.factory = FactoryDefinitionParser.FactoryDefinitionParserFactory.getInstance(alias, this.appContext).parse(definition);
        }
        this.beanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo(this.beanIdName, this.beanClassName.orElse(null), this.appContext);
        if (this.factory == null) {
            this.checkForDefaultConstructor();
        } else if (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
            throw new SmooksConfigException("Using a factory with an array is not supported");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BeanInstanceCreator created for [" + this.beanIdName + "]. BeanRuntimeInfo: " + this.beanRuntimeInfo);
        }
        if ((initValExpressions = this.config.getParameters(INIT_VAL_EXPRESSION)) != null && !initValExpressions.isEmpty()) {
            StringBuilder initValsExpressionString = new StringBuilder();
            for (Parameter initValExpression : initValExpressions) {
                initValsExpressionString.append(initValExpression.getValue());
                initValsExpressionString.append("\n");
            }
            this.initValsExpression = new MVELExpressionEvaluator();
            this.initValsExpression.setExpression(initValsExpressionString.toString());
        }
    }

    public void handle(ContentDeliveryConfigBuilderLifecycleEvent event) throws SmooksConfigException {
        if (event == ContentDeliveryConfigBuilderLifecycleEvent.CONTENT_DELIVERY_BUILDER_CREATED) {
            ModelSet.build(this.appContext);
        }
    }

    public BeanRuntimeInfo getBeanRuntimeInfo() {
        return this.beanRuntimeInfo;
    }

    private void buildId() {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(BeanInstanceCreator.class.getName());
        idBuilder.append("#");
        idBuilder.append(this.beanIdName);
        this.id = idBuilder.toString();
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.createAndSetBean(executionContext, (Fragment)new NodeFragment((Node)element));
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.visitAfter(executionContext, (Fragment)new NodeFragment((Node)element));
    }

    public void visitAfter(ExecutionContext executionContext, Fragment source) {
        BeanRuntimeInfo.Classification thisBeanType = this.beanRuntimeInfo.getClassification();
        boolean isBeanTypeArray = thisBeanType == BeanRuntimeInfo.Classification.ARRAY_COLLECTION;
        BeanContext beanContext = executionContext.getBeanContext();
        beanContext.setBeanInContext(this.beanId, false);
        if (isBeanTypeArray) {
            Object bean = beanContext.getBean(this.beanId);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Converting bean [" + this.beanIdName + "] to an array and rebinding to context.");
            }
            bean = this.convert(executionContext, bean, source);
        }
    }

    private Object convert(ExecutionContext executionContext, Object bean, Fragment source) {
        bean = BeanUtils.convertListToArray((List)bean, this.beanRuntimeInfo.getArrayType());
        executionContext.getBeanContext().changeBean(this.beanId, bean, source);
        return bean;
    }

    private void createAndSetBean(ExecutionContext executionContext, Fragment source) {
        BeanContext beanContext = executionContext.getBeanContext();
        Object bean = this.createBeanInstance(executionContext);
        executionContext.getBeanContext().notifyObservers((BeanContextLifecycleEvent)new DefaultBeanContextLifecycleEvent(executionContext, source, BeanLifecycle.START_FRAGMENT, this.beanId, bean));
        if (this.initValsExpression != null) {
            this.initValsExpression.exec(bean);
        }
        beanContext.setBeanInContext(this.beanId, false);
        beanContext.addBean(this.beanId, bean, source);
        beanContext.setBeanInContext(this.beanId, true);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Bean [" + this.beanIdName + "] instance created.");
        }
    }

    private Object createBeanInstance(ExecutionContext executionContext) {
        Object bean;
        if (this.factory == null) {
            try {
                bean = this.beanRuntimeInfo.getPopulateType().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new SmooksConfigException("Unable to create bean instance [" + this.beanIdName + ":" + this.beanRuntimeInfo.getPopulateType().getName() + "].", (Throwable)e);
            }
        }
        try {
            bean = this.factory.create(executionContext);
        }
        catch (RuntimeException e) {
            throw new SmooksConfigException("The factory was unable to create the bean instance [" + this.beanIdName + "] using the factory '" + this.factory + "'.", (Throwable)e);
        }
        return bean;
    }

    public Set<?> getProducts() {
        return CollectionsUtil.toSet((Object[])new String[]{this.beanIdName});
    }

    private String getId() {
        return this.id;
    }

    public String toString() {
        return this.getId();
    }

    private static String toClassName(Class<?> beanClass) {
        if (!beanClass.isArray()) {
            return beanClass.getName();
        }
        return beanClass.getComponentType().getName() + "[]";
    }

    private void checkForDefaultConstructor() {
        try {
            this.beanRuntimeInfo.getPopulateType().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new SmooksConfigException("Invalid Smooks bean configuration.  Bean class " + this.beanRuntimeInfo.getPopulateType().getName() + " doesn't have a public default constructor.");
        }
    }

    public void executeVisitLifecycleCleanup(Fragment fragment, ExecutionContext executionContext) {
        BeanContext beanContext = executionContext.getBeanContext();
        Object bean = beanContext.getBean(this.beanId);
        beanContext.notifyObservers((BeanContextLifecycleEvent)new DefaultBeanContextLifecycleEvent(executionContext, fragment, BeanLifecycle.END_FRAGMENT, this.beanId, bean));
        if (!this.retain.booleanValue()) {
            beanContext.removeBean(this.beanId, null);
        }
    }
}

