/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.javabean.BindingAppender;
import org.smooks.cartridges.javabean.ValueBinder;
import org.smooks.cartridges.javabean.ext.SelectorPropertyResolver;
import org.smooks.engine.converter.TypeConverterFactoryLoader;
import org.smooks.engine.delivery.DefaultContentHandlerBinding;
import org.smooks.engine.lookup.converter.SourceTargetTypeConverterFactoryLookup;
import org.smooks.engine.resource.config.DefaultResourceConfig;

public class Value
extends BindingAppender {
    private static final Set<TypeConverterFactory<?, ?>> TYPE_CONVERTER_FACTORIES = new TypeConverterFactoryLoader().load();
    private String dataSelector;
    private String targetNamespace;
    private String defaultValue;
    private TypeConverter<? super String, ?> typeConverter;

    public Value(String beanId, String data) {
        super(beanId);
        AssertArgument.isNotNullAndNotEmpty((String)beanId, (String)"beanId");
        AssertArgument.isNotNullAndNotEmpty((String)data, (String)"dataSelector");
        this.dataSelector = data;
    }

    public Value(String beanId, String data, Class<?> type) {
        this(beanId, data);
        AssertArgument.isNotNull(type, (String)"type");
        this.typeConverter = new SourceTargetTypeConverterFactoryLookup(String.class, type).lookup(TYPE_CONVERTER_FACTORIES).createTypeConverter();
    }

    public Value setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
        return this;
    }

    public Value setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Value setType(Class<?> type) {
        this.typeConverter = new SourceTargetTypeConverterFactoryLookup(String.class, type).lookup(TYPE_CONVERTER_FACTORIES).createTypeConverter();
        return this;
    }

    public Value setTypeConverter(TypeConverter<String, ?> typeConverter) {
        this.typeConverter = typeConverter;
        return this;
    }

    public List<ContentHandlerBinding<Visitor>> addVisitors() {
        ArrayList<ContentHandlerBinding<Visitor>> visitorBindings = new ArrayList<ContentHandlerBinding<Visitor>>();
        ValueBinder valueBinder = new ValueBinder(this.getBeanId());
        DefaultResourceConfig valueBinderSmooksResourceConfiguration = new DefaultResourceConfig(this.dataSelector);
        SelectorPropertyResolver.resolveSelectorTokens((ResourceConfig)valueBinderSmooksResourceConfiguration);
        valueBinder.setTypeConverter(this.typeConverter);
        valueBinder.setDefaultValue(this.defaultValue);
        valueBinder.setValueAttributeName((String)valueBinderSmooksResourceConfiguration.getParameterValue("valueAttributeName", String.class));
        visitorBindings.add((ContentHandlerBinding<Visitor>)new DefaultContentHandlerBinding((ContentHandler)valueBinder, valueBinderSmooksResourceConfiguration.getSelectorPath().getSelector(), this.targetNamespace, this.registry));
        return visitorBindings;
    }
}

