/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.binding.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.api.resource.config.xpath.SelectorPath;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.cartridges.javabean.BeanInstanceCreator;
import org.smooks.cartridges.javabean.BeanInstancePopulator;
import org.smooks.cartridges.javabean.binding.model.Bean;
import org.smooks.cartridges.javabean.binding.model.Binding;
import org.smooks.cartridges.javabean.binding.model.DataBinding;
import org.smooks.cartridges.javabean.binding.model.WiredBinding;
import org.smooks.engine.lookup.ContentHandlerFactoryLookup;
import org.smooks.engine.lookup.UserDefinedResourceConfigListLookup;
import org.smooks.engine.resource.config.xpath.DefaultSelectorPath;
import org.smooks.engine.xml.NamespaceManager;
import org.smooks.support.DollarBraceDecoder;

public class ModelSet {
    private Map<String, Bean> baseBeans = new LinkedHashMap<String, Bean>();
    private Map<String, Bean> models = new LinkedHashMap<String, Bean>();
    private Boolean isBindingOnlyConfig;

    private ModelSet(ResourceConfigSeq userConfigList, ContentHandlerFactory<?> javaContentHandlerFactory) throws SmooksConfigException {
        this.createBaseBeanMap(userConfigList, javaContentHandlerFactory);
        this.createExpandedModels();
        this.resolveModelSelectors(userConfigList);
    }

    public Bean getModel(String beanId) {
        return this.models.get(beanId);
    }

    public Bean getModel(Class<?> beanType) {
        for (Bean model : this.models.values()) {
            if (model.getCreator().getBeanRuntimeInfo().getPopulateType() != beanType) continue;
            return model;
        }
        return null;
    }

    public Map<String, Bean> getModels() {
        return this.models;
    }

    public boolean isBindingOnlyConfig() {
        return this.isBindingOnlyConfig;
    }

    private void createBaseBeanMap(ResourceConfigSeq resourceConfigList, ContentHandlerFactory<?> contentHandlerFactory) {
        for (int i = 0; i < resourceConfigList.size(); ++i) {
            Bean bean;
            ResourceConfig resourceConfig = resourceConfigList.get(i);
            Object javaResource = resourceConfig.isJavaResource() ? contentHandlerFactory.create(resourceConfig) : null;
            if (javaResource instanceof BeanInstanceCreator) {
                BeanInstanceCreator beanCreator = (BeanInstanceCreator)javaResource;
                bean = new Bean(beanCreator).setCloneable(true);
                this.baseBeans.put(bean.getBeanId(), bean);
                if (this.isBindingOnlyConfig != null) continue;
                this.isBindingOnlyConfig = true;
                continue;
            }
            if (javaResource instanceof BeanInstancePopulator) {
                BeanInstancePopulator beanPopulator = (BeanInstancePopulator)javaResource;
                bean = this.baseBeans.get(beanPopulator.getBeanId());
                if (bean == null) {
                    throw new SmooksConfigException("Unexpected binding configuration exception.  Unknown parent beanId '' for binding configuration.");
                }
                if (beanPopulator.isBeanWiring()) {
                    bean.getBindings().add(new WiredBinding(beanPopulator));
                    continue;
                }
                bean.getBindings().add(new DataBinding(beanPopulator));
                continue;
            }
            if (!this.isNonBindingResource(javaResource) || this.isGlobalParamsConfig(resourceConfig)) continue;
            this.isBindingOnlyConfig = false;
        }
    }

    private boolean isNonBindingResource(Object javaResource) {
        if (javaResource instanceof TypeConverter) {
            return false;
        }
        return !(javaResource instanceof NamespaceManager);
    }

    private boolean isGlobalParamsConfig(ResourceConfig config) {
        return "global-parameters".equals(config.getSelectorPath().getSelector());
    }

    private void createExpandedModels() {
        for (Bean bean : this.baseBeans.values()) {
            this.models.put(bean.getBeanId(), bean.clone(this.baseBeans, null));
        }
    }

    private void resolveModelSelectors(ResourceConfigSeq userConfigList) {
        for (Bean model : this.models.values()) {
            this.resolveModelSelectors(model);
        }
        for (int i = 0; i < userConfigList.size(); ++i) {
            this.expandSelector(userConfigList.get(i), false, null);
        }
    }

    private void resolveModelSelectors(Bean model) {
        ResourceConfig beanConfig = model.getConfig();
        this.expandSelector(beanConfig, true, null);
        for (Binding binding : model.getBindings()) {
            ResourceConfig bindingConfig = binding.getConfig();
            this.expandSelector(bindingConfig, true, beanConfig);
            if (!(binding instanceof WiredBinding)) continue;
            this.resolveModelSelectors(((WiredBinding)binding).getWiredBean());
        }
    }

    private void expandSelector(ResourceConfig resourceConfiguration, boolean failOnMissingBean, ResourceConfig context) {
        SelectorPath selectorPath = resourceConfiguration.getSelectorPath();
        QName targetElement = ((SelectorStep)selectorPath.get(0)).getElement();
        if (targetElement == null) {
            return;
        }
        String localPart = targetElement.getLocalPart();
        if (localPart.equals("#") && context != null) {
            resourceConfiguration.setSelectorPath(this.concat(context.getSelectorPath(), selectorPath));
            return;
        }
        List dollarBraceTokens = DollarBraceDecoder.getTokens((String)localPart);
        if (dollarBraceTokens.size() == 1) {
            String beanId = (String)dollarBraceTokens.get(0);
            Bean bean = this.baseBeans.get(beanId);
            if (bean != null) {
                resourceConfiguration.setSelectorPath(this.concat(bean.getConfig().getSelectorPath(), selectorPath));
            } else if (failOnMissingBean) {
                throw new SmooksConfigException("Invalid selector '" + selectorPath.toString() + "'.  Unknown beanId '" + beanId + "'.");
            }
        }
    }

    private SelectorPath concat(SelectorPath context, SelectorPath beanSelectorPath) {
        DefaultSelectorPath newSelectorPath = new DefaultSelectorPath();
        newSelectorPath.addAll((Collection)Stream.concat(context.stream(), beanSelectorPath.subList(1, beanSelectorPath.size()).stream()).collect(Collectors.toList()));
        return newSelectorPath;
    }

    public static void build(ApplicationContext appContext) {
        ModelSet modelSet = ModelSet.get(appContext);
        if (modelSet == null) {
            modelSet = new ModelSet((ResourceConfigSeq)appContext.getRegistry().lookup((Function)new UserDefinedResourceConfigListLookup(appContext.getRegistry())), (ContentHandlerFactory)appContext.getRegistry().lookup((Function)new ContentHandlerFactoryLookup("class")));
            appContext.getRegistry().registerObject(ModelSet.class, (Object)modelSet);
        }
    }

    public static ModelSet get(ApplicationContext appContext) {
        return (ModelSet)appContext.getRegistry().lookup(ModelSet.class);
    }
}

