/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.dynamic;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.smooks.Smooks;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.javabean.dynamic.ext.BeanWriterFactory;
import org.smooks.cartridges.javabean.dynamic.resolvers.AbstractResolver;
import org.smooks.cartridges.javabean.dynamic.resolvers.DefaultBindingConfigResolver;
import org.smooks.cartridges.javabean.dynamic.resolvers.DefaultSchemaResolver;
import org.smooks.cartridges.javabean.dynamic.serialize.BeanWriter;
import org.smooks.engine.DefaultApplicationContextBuilder;
import org.smooks.engine.resource.config.XMLConfigDigester;
import org.smooks.support.ClassUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Descriptor {
    public static final String DESCRIPTOR_NAMESPACE_POSTFIX = ".namespace";
    public static final String DESCRIPTOR_SCHEMA_LOCATION_POSTFIX = ".schemaLocation";
    public static final String DESCRIPTOR_BINDING_CONFIG_LOCATION_POSTFIX = ".bindingConfigLocation";
    public static final String DESCRIPTOR_ORDER_POSTFIX = ".order";
    private Smooks smooks;
    private Schema schema;
    private ClassLoader classloader = Descriptor.class.getClassLoader();

    public Descriptor(List<Properties> descriptors) throws SAXException, IOException {
        AssertArgument.isNotNullAndNotEmpty(descriptors, (String)"descriptors");
        this.intialize(descriptors, new DefaultSchemaResolver(descriptors), new DefaultBindingConfigResolver(descriptors));
    }

    public Descriptor(String descriptorPath) throws SAXException, IOException {
        AssertArgument.isNotNullAndNotEmpty((String)descriptorPath, (String)"descriptorPath");
        List<Properties> descriptors = Descriptor.loadDescriptors(descriptorPath, this.getClass().getClassLoader());
        this.intialize(descriptors, new DefaultSchemaResolver(descriptors), new DefaultBindingConfigResolver(descriptors));
    }

    public Descriptor(String descriptorPath, EntityResolver schemaResolver, EntityResolver bindingResolver, ClassLoader classloader) throws SAXException, IOException {
        AssertArgument.isNotNullAndNotEmpty((String)descriptorPath, (String)"descriptorPath");
        AssertArgument.isNotNull((Object)bindingResolver, (String)"bindingResolver");
        AssertArgument.isNotNull((Object)classloader, (String)"classloader");
        this.classloader = classloader;
        List<Properties> descriptors = Descriptor.loadDescriptors(descriptorPath, classloader);
        this.intialize(descriptors, schemaResolver, bindingResolver);
    }

    public Descriptor(List<Properties> descriptors, EntityResolver schemaResolver, EntityResolver bindingResolver, ClassLoader classloader) throws SAXException, IOException {
        AssertArgument.isNotNullAndNotEmpty(descriptors, (String)"descriptors");
        AssertArgument.isNotNull((Object)bindingResolver, (String)"bindingResolver");
        AssertArgument.isNotNull((Object)classloader, (String)"classloader");
        this.classloader = classloader;
        this.intialize(descriptors, schemaResolver, bindingResolver);
    }

    public Smooks getSmooks() {
        return this.smooks;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Map<Class<?>, Map<String, BeanWriter>> getBeanWriters() {
        return BeanWriterFactory.getBeanWriters(this.smooks.getApplicationContext());
    }

    public static List<Properties> loadDescriptors(String descriptorPath, ClassLoader classLoader) {
        ArrayList<Properties> descriptorFiles = new ArrayList<Properties>();
        try {
            List resources = ClassUtil.getResources((String)descriptorPath, (ClassLoader)classLoader);
            if (resources.isEmpty()) {
                throw new IllegalStateException("Failed to locate any model descriptor file by the name '" + descriptorPath + "' on the classpath.");
            }
            for (URL resource : resources) {
                InputStream resStream = resource.openStream();
                descriptorFiles.add(Descriptor.loadDescriptor(resStream));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO Exception when reading Dynamic Namespace Descriptor files from classpath.", e);
        }
        return descriptorFiles;
    }

    public static Properties loadDescriptor(InputStream descriptorStream) throws IOException {
        AssertArgument.isNotNull((Object)descriptorStream, (String)"descriptorStream");
        try {
            Properties descriptor = new Properties();
            descriptor.load(descriptorStream);
            Properties properties = descriptor;
            return properties;
        }
        finally {
            descriptorStream.close();
        }
    }

    private void intialize(List<Properties> descriptors, EntityResolver schemaResolver, EntityResolver bindingResolver) throws SAXException, IOException {
        if (schemaResolver instanceof AbstractResolver && ((AbstractResolver)schemaResolver).getClassLoader() != this.classloader) {
            throw new SmooksException("Schema EntityResolver '" + schemaResolver.getClass().getName() + "' not using the same ClassLoader as this Descriptor instance.");
        }
        if (bindingResolver instanceof AbstractResolver && ((AbstractResolver)bindingResolver).getClassLoader() != this.classloader) {
            throw new SmooksException("Binding EntityResolver '" + bindingResolver.getClass().getName() + "' not using the same ClassLoader as this Descriptor instance.");
        }
        if (schemaResolver != null) {
            this.schema = this.newSchemaInstance(descriptors, schemaResolver);
        }
        this.smooks = this.newSmooksInstance(descriptors, bindingResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema newSchemaInstance(List<Properties> descriptors, EntityResolver schemaResolver) throws SAXException, IOException {
        List<Source> schemas = this.getSchemas(descriptors, schemaResolver);
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemas.toArray(new Source[schemas.size()]));
            return schema;
        }
        finally {
            for (Source schemaSource : schemas) {
                if (!(schemaSource instanceof StreamSource)) continue;
                StreamSource streamSource = (StreamSource)schemaSource;
                if (streamSource.getInputStream() != null) {
                    streamSource.getInputStream().close();
                    continue;
                }
                if (streamSource.getReader() == null) continue;
                streamSource.getReader().close();
            }
        }
    }

    private List<Source> getSchemas(List<Properties> descriptors, EntityResolver schemaResolver) throws SAXException, IOException {
        Set<Namespace> namespaces = Descriptor.resolveNamespaces(descriptors);
        ArrayList<Source> xsdSources = new ArrayList<Source>();
        for (Namespace namespace : namespaces) {
            InputSource schemaSource = schemaResolver.resolveEntity(namespace.uri, namespace.uri);
            if (schemaSource == null) continue;
            if (schemaSource.getByteStream() != null) {
                xsdSources.add(new StreamSource(schemaSource.getByteStream()));
                continue;
            }
            if (schemaSource.getCharacterStream() != null) {
                xsdSources.add(new StreamSource(schemaSource.getCharacterStream()));
                continue;
            }
            throw new SAXException("Schema resolver '" + schemaResolver.getClass().getName() + "' failed to resolve schema for namespace '" + namespace + "'.  Resolver must return a Reader or InputStream in the InputSource.");
        }
        return xsdSources;
    }

    private Smooks newSmooksInstance(List<Properties> descriptors, EntityResolver bindingResolver) throws SAXException, IOException {
        AssertArgument.isNotNullAndNotEmpty(descriptors, (String)"descriptors");
        AssertArgument.isNotNull((Object)bindingResolver, (String)"bindingResolver");
        Set<Namespace> namespaces = Descriptor.resolveNamespaces(descriptors);
        HashMap extendedConfigDigesters = new HashMap();
        Smooks smooks = new Smooks(new DefaultApplicationContextBuilder().setClassLoader(this.classloader).build());
        for (Namespace namespace : namespaces) {
            InputSource bindingSource = bindingResolver.resolveEntity(namespace.uri, namespace.uri);
            if (bindingSource == null) continue;
            if (bindingSource.getByteStream() != null) {
                ResourceConfigSeq resourceConfigSeq;
                try {
                    resourceConfigSeq = XMLConfigDigester.digestConfig((InputStream)bindingSource.getByteStream(), (String)"./", extendedConfigDigesters, (ClassLoader)this.classloader);
                    for (int i = 0; i < resourceConfigSeq.size(); ++i) {
                        SelectorStep selectorStep;
                        ResourceConfig config = resourceConfigSeq.get(i);
                        if (config.getSelectorPath().getSelectorNamespaceURI() != null || !(selectorStep = config.getSelectorPath().getTargetSelectorStep()).getElement().getPrefix().equals("")) continue;
                        config.getSelectorPath().setSelectorNamespaceURI(namespace.uri);
                    }
                }
                catch (URISyntaxException e) {
                    throw new SmooksConfigException("Unexpected configuration digest exception.", (Throwable)e);
                }
                smooks.getApplicationContext().getRegistry().registerResourceConfigList(resourceConfigSeq);
                continue;
            }
            throw new SAXException("Binding configuration resolver '" + bindingResolver.getClass().getName() + "' failed to resolve binding configuration for namespace '" + namespace + "'.  Resolver must return an InputStream in the InputSource.");
        }
        return smooks;
    }

    private static Set<Namespace> resolveNamespaces(List<Properties> descriptors) {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (Properties descriptor : descriptors) {
            Descriptor.extractNamespaceDecls(descriptor, namespaces);
        }
        Comparator<Namespace> namspaceSorter = new Comparator<Namespace>(){

            @Override
            public int compare(Namespace o1, Namespace o2) {
                return o1.order - o2.order;
            }
        };
        Namespace[] namespaceArray = new Namespace[namespaces.size()];
        namespaces.toArray(namespaceArray);
        Arrays.sort(namespaceArray, namspaceSorter);
        LinkedHashSet<Namespace> orderedNamespaceSet = new LinkedHashSet<Namespace>();
        orderedNamespaceSet.addAll(Arrays.asList(namespaceArray));
        return orderedNamespaceSet;
    }

    private static List<Namespace> extractNamespaceDecls(Properties descriptor, List<Namespace> namespaces) {
        Set<Map.Entry<Object, Object>> properties = descriptor.entrySet();
        for (Map.Entry<Object, Object> property : properties) {
            String key = ((String)property.getKey()).trim();
            if (!key.endsWith(DESCRIPTOR_NAMESPACE_POSTFIX)) continue;
            Namespace namespace = new Namespace();
            String namespaceUri = (String)property.getValue();
            String namespaceId = Descriptor.getNamespaceId(namespaceUri, descriptor);
            if (namespaceId == null) {
                throw new SmooksConfigException("Unable to resolve namespace ID for namespace URI '" + namespaceUri + "'.");
            }
            String namespaceOrder = descriptor.getProperty(namespaceId + DESCRIPTOR_ORDER_POSTFIX, Integer.toString(Integer.MAX_VALUE)).trim();
            namespace.uri = namespaceUri;
            try {
                namespace.order = Integer.parseInt(namespaceOrder);
            }
            catch (NumberFormatException e) {
                throw new SmooksConfigException("Invalid value for descriptor config value '" + namespaceId + DESCRIPTOR_ORDER_POSTFIX + "'.  Must be a valid Integer value.");
            }
            namespaces.add(namespace);
        }
        return namespaces;
    }

    public static String getNamespaceId(String namespaceURI, List<Properties> descriptors) {
        for (Properties descriptor : descriptors) {
            String id = Descriptor.getNamespaceId(namespaceURI, descriptor);
            if (id == null) continue;
            return id;
        }
        return null;
    }

    private static String getNamespaceId(String namespaceURI, Properties descriptor) {
        Set<Map.Entry<Object, Object>> properties = descriptor.entrySet();
        for (Map.Entry<Object, Object> property : properties) {
            String key = ((String)property.getKey()).trim();
            String value = ((String)property.getValue()).trim();
            if (!key.endsWith(DESCRIPTOR_NAMESPACE_POSTFIX) || !value.equals(namespaceURI)) continue;
            return key.substring(0, key.length() - DESCRIPTOR_NAMESPACE_POSTFIX.length());
        }
        return null;
    }

    public static String getSchemaLocation(String namespaceId, List<Properties> descriptors) {
        return Descriptor.getDescriptorValue(namespaceId + DESCRIPTOR_SCHEMA_LOCATION_POSTFIX, descriptors);
    }

    public static String getBindingConfigLocation(String namespaceId, List<Properties> descriptors) {
        return Descriptor.getDescriptorValue(namespaceId + DESCRIPTOR_BINDING_CONFIG_LOCATION_POSTFIX, descriptors);
    }

    private static String getDescriptorValue(String name, List<Properties> descriptors) {
        for (Properties descriptor : descriptors) {
            String value = descriptor.getProperty(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static class Namespace {
        private String uri;
        private int order;

        private Namespace() {
        }
    }
}

