/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.dynamic.serialize.freemarker;

import freemarker.core.Environment;
import freemarker.ext.beans.BeanModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.cartridges.javabean.dynamic.BeanMetadata;
import org.smooks.cartridges.javabean.dynamic.BeanRegistrationException;
import org.smooks.cartridges.javabean.dynamic.Model;
import org.smooks.cartridges.javabean.dynamic.serialize.BeanWriter;
import org.smooks.cartridges.javabean.dynamic.serialize.freemarker.AbstractBeanDirective;
import org.smooks.support.XmlUtil;

public class WriteBeanDirective
extends AbstractBeanDirective {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteBeanDirective.class);

    public void execute(Environment environment, Map params, TemplateModel[] templateModels, TemplateDirectiveBody templateDirectiveBody) throws TemplateException, IOException {
        BeanModel modelBeanModel;
        Model model;
        BeanMetadata beanMetadata;
        Object bean = this.getBeanObject(environment, params, "writeBean");
        SimpleScalar indentScalar = (SimpleScalar)params.get("indent");
        int indent = 0;
        if (indentScalar != null) {
            String indentParamVal = indentScalar.getAsString().trim();
            try {
                indent = Integer.parseInt(indentParamVal);
                indent = Math.min(indent, 100);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Invalid <@writeNamespaces> 'indent' parameter value '" + indentParamVal + "'.  Must be a valid integer (<= 100).");
            }
        }
        if ((beanMetadata = (model = (Model)(modelBeanModel = (BeanModel)environment.getDataModel().get("dyna_model_inst")).getWrappedObject()).getBeanMetadata(bean)) == null) {
            BeanRegistrationException.throwUnregisteredBeanInstanceException(bean);
        }
        BeanWriter beanWriter = beanMetadata.getWriter();
        if (beanMetadata.getPreText() != null) {
            environment.getOut().write(beanMetadata.getPreText());
        }
        if (indent > 0) {
            StringWriter beanWriteBuffer = new StringWriter();
            beanWriteBuffer.write(10);
            beanWriter.write(bean, beanWriteBuffer, model);
            environment.getOut().write(XmlUtil.indent((String)beanWriteBuffer.toString(), (int)indent));
        } else {
            beanWriter.write(bean, environment.getOut(), model);
        }
    }
}

