/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.ext;

import java.util.UUID;
import java.util.function.Function;
import javax.inject.Inject;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.engine.converter.PreprocessTypeConverter;
import org.smooks.engine.lookup.converter.NameTypeConverterFactoryLookup;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.smooks.engine.resource.extension.ExtensionContext;
import org.smooks.support.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DecodeParamResolver
implements DOMVisitBefore {
    @Inject
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        NodeList decodeParams = element.getElementsByTagNameNS(element.getNamespaceURI(), "decodeParam");
        if (decodeParams.getLength() > 0) {
            ExtensionContext extensionContext = (ExtensionContext)executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY);
            ResourceConfig populatorConfig = (ResourceConfig)extensionContext.getResourceStack().peek();
            DefaultResourceConfig typeConverterConfig = new DefaultResourceConfig();
            extensionContext.addResource((ResourceConfig)typeConverterConfig);
            try {
                String type = (String)populatorConfig.getParameterValue("type", String.class);
                TypeConverterFactory typeConverterFactory = (TypeConverterFactory)this.applicationContext.getRegistry().lookup((Function)new NameTypeConverterFactoryLookup(type));
                String reType = UUID.randomUUID().toString();
                populatorConfig.removeParameter("type");
                populatorConfig.setParameter("type", (Object)reType);
                typeConverterConfig.setSelector("decoder:" + reType);
                typeConverterConfig.setTargetProfile(extensionContext.getDefaultProfile());
                if (type != null) {
                    typeConverterConfig.setResource(typeConverterFactory.createTypeConverter().getClass().getName());
                }
                for (int i = 0; i < decodeParams.getLength(); ++i) {
                    Element decoderParam = (Element)decodeParams.item(i);
                    String name = decoderParam.getAttribute("name");
                    if (name.equals("valuePreprocess")) {
                        typeConverterConfig.setResource(PreprocessTypeConverter.class.getName());
                        if (type != null) {
                            typeConverterConfig.setParameter("baseDecoder", (Object)typeConverterFactory.getClass().getName());
                        }
                    }
                    typeConverterConfig.setParameter(name, (Object)DomUtils.getAllText((Element)decoderParam, (boolean)true));
                }
            }
            finally {
                extensionContext.getResourceStack().pop();
            }
        }
    }
}

