/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.ext;

import java.util.Collection;
import java.util.Map;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.support.ClassUtil;
import org.smooks.support.DomUtils;
import org.w3c.dom.Element;

public class PropertyChecker
implements DOMVisitBefore {
    public void visitBefore(Element element, ExecutionContext execContext) throws SmooksException {
        BeanType beanType = this.getBeanType(element);
        boolean isPropertSpecified = DomUtils.getAttributeValue((Element)element, (String)"property") != null;
        boolean isSetterMethodSpecified = DomUtils.getAttributeValue((Element)element, (String)"setterMethod") != null;
        String bindingType = DomUtils.getName((Element)element);
        if (isPropertSpecified && isSetterMethodSpecified) {
            throw new SmooksConfigException("'" + bindingType + "' binding specifies a 'property' and a 'setterMethod' attribute.  Only one of both may be set.");
        }
        if (isPropertSpecified && beanType == BeanType.COLLECTION) {
            throw new SmooksConfigException("'" + bindingType + "' binding specifies a 'property' attribute.  This is not valid for a Collection target.");
        }
        if (isPropertSpecified && beanType == BeanType.ARRAY) {
            throw new SmooksConfigException("'" + bindingType + "' binding specifies a 'property' attribute.  This is not valid for an Array target.");
        }
        if (isSetterMethodSpecified && beanType == BeanType.COLLECTION) {
            throw new SmooksConfigException("'" + bindingType + "' binding specifies a 'setterMethod' attribute.  This is not valid for a Collection target.");
        }
        if (isSetterMethodSpecified && beanType == BeanType.ARRAY) {
            throw new SmooksConfigException("'" + bindingType + "' binding specifies a 'setterMethod' attribute.  This is not valid for an Array target.");
        }
        if (!isPropertSpecified && !isSetterMethodSpecified && beanType == BeanType.OTHER) {
            throw new SmooksConfigException("'" + bindingType + "' binding for bean class '" + this.getBeanTypeName(element) + "' must specify a 'property' or 'setterMethod' attribute.");
        }
    }

    private BeanType getBeanType(Element bindingElement) {
        String beanClassName = this.getBeanTypeName(bindingElement);
        if (beanClassName.endsWith("[]")) {
            return BeanType.ARRAY;
        }
        Class<?> beanClass = this.getBeanClass(bindingElement);
        if (Collection.class.isAssignableFrom(beanClass)) {
            return BeanType.COLLECTION;
        }
        if (Map.class.isAssignableFrom(beanClass)) {
            return BeanType.MAP;
        }
        return BeanType.OTHER;
    }

    private Class<?> getBeanClass(Element bindingElement) {
        Class beanClass;
        String beanClassName = this.getBeanTypeName(bindingElement);
        try {
            beanClass = ClassUtil.forName((String)beanClassName, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new SmooksConfigException("Bean class '" + beanClassName + "' not available on classpath.");
        }
        return beanClass;
    }

    private String getBeanTypeName(Element bindingElement) {
        return ((Element)bindingElement.getParentNode()).getAttribute("class");
    }

    private static enum BeanType {
        ARRAY,
        COLLECTION,
        MAP,
        OTHER;

    }
}

