/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.factory;

import java.util.concurrent.ConcurrentHashMap;
import org.smooks.cartridges.javabean.factory.Factory;
import org.smooks.cartridges.javabean.factory.FactoryDefinitionParser;

public abstract class AbstractCachingFactoryDefinitionParser
implements FactoryDefinitionParser {
    private final ConcurrentHashMap<String, Factory<?>> factoryCache = new ConcurrentHashMap();

    @Override
    public Factory<?> parse(String factoryDefinition) {
        Factory<?> factory = this.factoryCache.get(factoryDefinition);
        if (factory == null) {
            factory = this.createFactory(factoryDefinition);
            if (factory == null) {
                throw new NullPointerException("Null was returned by the createFactory method.");
            }
            Factory<?> cachedFactory = this.factoryCache.putIfAbsent(factoryDefinition, factory);
            if (cachedFactory != null) {
                factory = cachedFactory;
            }
        }
        return factory;
    }

    protected abstract Factory<?> createFactory(String var1);
}

