/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.factory;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.cartridges.javabean.factory.Alias;
import org.smooks.cartridges.javabean.factory.Factory;
import org.smooks.cartridges.javabean.factory.IllegalFactoryAliasException;
import org.smooks.engine.lookup.GlobalParamsLookup;
import org.smooks.support.ClassUtil;

public interface FactoryDefinitionParser {
    public Factory<?> parse(String var1);

    public static class FactoryDefinitionParserFactory {
        private static final Logger LOGGER = LoggerFactory.getLogger(FactoryDefinitionParserFactory.class);
        public static String GLOBAL_DEFAULT_FACTORY_DEFINITION_PARSER_CLASS = "factory.definition.parser.class";
        public static String DEFAULT_FACTORY_DEFINITION_PARSER_CLASS = "org.smooks.cartridges.javabean.factory.BasicFactoryDefinitionParser";
        public static final String DEFAULT_ALIAS = "default";
        private static volatile ConcurrentMap<String, FactoryDefinitionParser> instances = new ConcurrentHashMap<String, FactoryDefinitionParser>();
        private static volatile Map<String, Class<? extends FactoryDefinitionParser>> aliasToClassMap;

        public static FactoryDefinitionParser getInstance(String alias, ApplicationContext applicationContext) {
            String className;
            if (StringUtils.isEmpty((String)alias) || alias.equals(DEFAULT_ALIAS)) {
                className = (String)((ResourceConfig)applicationContext.getRegistry().lookup((Function)new GlobalParamsLookup(applicationContext.getRegistry()))).getParameterValue(GLOBAL_DEFAULT_FACTORY_DEFINITION_PARSER_CLASS, String.class, (Object)DEFAULT_FACTORY_DEFINITION_PARSER_CLASS);
            } else {
                FactoryDefinitionParserFactory.loadAliasToClassMap();
                Class clazz = aliasToClassMap.get(alias);
                if (clazz == null) {
                    try {
                        clazz = ClassUtil.forName((String)alias, FactoryDefinitionParser.class);
                        className = clazz.getName();
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalFactoryAliasException("The FactoryDefinitionParser alias '" + alias + "' can't be found and doesn't seem to be a classname.", e);
                    }
                }
                className = clazz.getName();
            }
            FactoryDefinitionParser factoryDefinitionParser = (FactoryDefinitionParser)instances.get(className);
            if (factoryDefinitionParser == null) {
                try {
                    Class factoryDefinitionParserClass = ClassUtil.forName((String)className, FactoryDefinitionParser.class);
                    FactoryDefinitionParser newFactoryDefinitionParser = (FactoryDefinitionParser)factoryDefinitionParserClass.newInstance();
                    instances.putIfAbsent(className, newFactoryDefinitionParser);
                    factoryDefinitionParser = (FactoryDefinitionParser)instances.get(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("The FactoryDefinitionParser class '" + className + "' can't be found", e);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("The FactoryDefinitionParser class '" + className + "'can't be instantiated. The FactoryDefinitionParser class must have a argumentless public constructor.", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("The FactoryDefinitionParser class '" + className + "' can't be instantiated.", e);
                }
            }
            return factoryDefinitionParser;
        }

        public static FactoryDefinitionParser getInstance(ApplicationContext applicationContext) {
            return FactoryDefinitionParserFactory.getInstance(DEFAULT_ALIAS, applicationContext);
        }

        public static Map<String, Class<? extends FactoryDefinitionParser>> getAliasToClassMap() {
            FactoryDefinitionParserFactory.loadAliasToClassMap();
            return Collections.unmodifiableMap(aliasToClassMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static synchronized void loadAliasToClassMap() throws TypeConverterException {
            if (aliasToClassMap != null) return;
            Class<FactoryDefinitionParserFactory> clazz = FactoryDefinitionParserFactory.class;
            synchronized (FactoryDefinitionParserFactory.class) {
                if (aliasToClassMap != null) return;
                List factories = ClassUtil.getClasses((String)"META-INF/smooks-javabean-factory-definition-parsers.inf", FactoryDefinitionParser.class);
                HashSet<String> toRemove = new HashSet<String>();
                aliasToClassMap = new HashMap<String, Class<? extends FactoryDefinitionParser>>();
                for (Class factory : factories) {
                    String[] names;
                    Alias alias = factory.getAnnotation(Alias.class);
                    if (alias == null) continue;
                    for (String name : names = alias.value()) {
                        if (name.equals(DEFAULT_ALIAS)) {
                            throw new IllegalFactoryAliasException("The alias 'default' is a reserved alias name. Please use a different name");
                        }
                        if (aliasToClassMap.containsKey(name)) {
                            Class<? extends FactoryDefinitionParser> prevClass = aliasToClassMap.get(name);
                            LOGGER.warn("More than one FactoryDefinitionParser has the alias '" + name + "' on the classpath. Previous: '" + prevClass.getName() + "'. Current '" + factory.getName() + "'. To use one of these factories you will have to declare the complete class name as alias.");
                            toRemove.add(name);
                        }
                        aliasToClassMap.put(name, factory);
                    }
                }
                for (String name : toRemove) {
                    aliasToClassMap.remove(name);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
    }
}

