/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.gen.model;

import java.lang.reflect.Field;
import java.util.Set;
import javax.annotation.Resource;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.TypeConverterFactoryLoader;
import org.smooks.engine.lookup.converter.SourceTargetTypeConverterFactoryLookup;

public class BindingConfig {
    private static final Set<TypeConverterFactory<?, ?>> TYPE_CONVERTER_FACTORIES = new TypeConverterFactoryLoader().load();
    private Field property;
    private String wireBeanId;

    public BindingConfig(Field property) {
        this.property = property;
    }

    public BindingConfig(String wireBeanId) {
        this.wireBeanId = wireBeanId;
    }

    public BindingConfig(Field property, String wireBeanId) {
        this.property = property;
        this.wireBeanId = wireBeanId;
    }

    public Field getProperty() {
        return this.property;
    }

    public String getSelector() {
        if (this.wireBeanId != null) {
            return this.wireBeanId;
        }
        return "$TODO$";
    }

    public boolean isWiring() {
        return this.wireBeanId != null;
    }

    public boolean isBoundToProperty() {
        return this.property != null;
    }

    public String getType() {
        Class<?> type = this.property.getType();
        if (type.isArray()) {
            return "$DELETE:NOT-APPLICABLE$";
        }
        TypeConverterFactory typeConverterFactory = new SourceTargetTypeConverterFactoryLookup(String.class, type).lookup(TYPE_CONVERTER_FACTORIES);
        if (typeConverterFactory != null && typeConverterFactory.getClass().isAnnotationPresent(Resource.class) && !typeConverterFactory.getClass().getAnnotation(Resource.class).name().equals("")) {
            return typeConverterFactory.getClass().getAnnotation(Resource.class).name();
        }
        return "$TODO$";
    }
}

