/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean;

import jakarta.annotation.PostConstruct;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.bean.context.BeanIdStore;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleEvent;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleObserver;
import org.smooks.api.bean.lifecycle.BeanLifecycle;
import org.smooks.api.bean.repository.BeanId;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.delivery.ordering.Producer;
import org.smooks.api.memento.Memento;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.VisitAfterReport;
import org.smooks.api.resource.visitor.VisitBeforeReport;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.api.resource.visitor.sax.ng.ChildrenVisitor;
import org.smooks.cartridges.javabean.Bean;
import org.smooks.cartridges.javabean.BeanRuntimeInfo;
import org.smooks.cartridges.javabean.BeanUtils;
import org.smooks.cartridges.javabean.observers.BeanWiringObserver;
import org.smooks.cartridges.javabean.observers.ListToArrayChangeObserver;
import org.smooks.engine.bean.lifecycle.DefaultBeanContextLifecycleEvent;
import org.smooks.engine.converter.PreprocessTypeConverter;
import org.smooks.engine.converter.StringConverterFactory;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.expression.MVELExpressionEvaluator;
import org.smooks.engine.lookup.NamespaceManagerLookup;
import org.smooks.engine.lookup.converter.NameTypeConverterFactoryLookup;
import org.smooks.engine.lookup.converter.SourceTargetTypeConverterFactoryLookup;
import org.smooks.engine.memento.TextAccumulatorVisitorMemento;
import org.smooks.support.ClassUtil;
import org.smooks.support.DomUtils;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@VisitBeforeReport(condition="parameters.containsKey('wireBeanId') || parameters.containsKey('valueAttributeName')", summary="<#if resource.parameters.wireBeanId??>Create bean lifecycle observer for bean <b>${resource.parameters.wireBeanId}</b>.<#else>Populating <b>${resource.parameters.beanId}</b> with the value from the attribute <b>${resource.parameters.valueAttributeName}</b>.</#if>", detailTemplate="reporting/BeanInstancePopulatorReport_Before.html")
@VisitAfterReport(condition="!parameters.containsKey('wireBeanId') && !parameters.containsKey('valueAttributeName')", summary="Populating <b>${resource.parameters.beanId}</b> with a value from this element.", detailTemplate="reporting/BeanInstancePopulatorReport_After.html")
public class BeanInstancePopulator
implements BeforeVisitor,
AfterVisitor,
ChildrenVisitor,
Producer,
Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanInstancePopulator.class);
    private static final String EXPRESSION_VALUE_VARIABLE_NAME = "_VALUE";
    public static final String VALUE_ATTRIBUTE_NAME = "valueAttributeName";
    public static final String VALUE_ATTRIBUTE_PREFIX = "valueAttributePrefix";
    public static final String NOTIFY_POPULATE = "org.smooks.cartridges.javabean.notify.populate";
    private String id;
    @Inject
    @Named(value="beanId")
    private String beanIdName;
    @Inject
    @Named(value="wireBeanId")
    private Optional<String> wireBeanIdName;
    @Inject
    private Optional<Class<?>> wireBeanType;
    @Inject
    private Optional<Class<? extends Annotation>> wireBeanAnnotation;
    @Inject
    private Optional<String> expression;
    private MVELExpressionEvaluator expressionEvaluator;
    private boolean expressionHasDataVariable = false;
    @Inject
    private Optional<String> property;
    @Inject
    private Optional<String> setterMethod;
    @Inject
    private Optional<String> valueAttributeName;
    @Inject
    private Optional<String> valueAttributePrefix;
    private String valueAttributeNS;
    @Inject
    @Named(value="type")
    private Optional<String> typeAlias;
    @Inject
    @Named(value="default")
    private Optional<String> defaultVal;
    @Inject
    @Named(value="org.smooks.cartridges.javabean.notify.populate")
    private Boolean notifyPopulate = false;
    @Inject
    private ResourceConfig config;
    @Inject
    private ApplicationContext appContext;
    private BeanIdStore beanIdStore;
    private BeanId beanId;
    private BeanId wireBeanId;
    private BeanRuntimeInfo beanRuntimeInfo;
    private BeanRuntimeInfo wiredBeanRuntimeInfo;
    private Method propertySetterMethod;
    private boolean checkedForSetterMethod;
    private boolean isAttribute = true;
    private TypeConverter<? super String, ?> typeConverter;
    private String mapKeyAttribute;
    private boolean isBeanWiring;
    private BeanWiringObserver wireByBeanIdObserver;
    private ListToArrayChangeObserver listToArrayChangeObserver;

    public ResourceConfig getConfig() {
        return this.config;
    }

    public void setBeanId(String beanId) {
        this.beanIdName = beanId;
    }

    public String getBeanId() {
        return this.beanIdName;
    }

    public void setWireBeanId(String wireBeanId) {
        this.wireBeanIdName = Optional.ofNullable(wireBeanId);
    }

    public String getWireBeanId() {
        return this.wireBeanIdName.orElse(null);
    }

    public void setExpression(MVELExpressionEvaluator expression) {
        this.expressionEvaluator = expression;
    }

    public void setProperty(String property) {
        this.property = Optional.ofNullable(property);
    }

    public String getProperty() {
        return this.property.orElse(null);
    }

    public void setSetterMethod(String setterMethod) {
        this.setterMethod = Optional.ofNullable(setterMethod);
    }

    public void setValueAttributeName(String valueAttributeName) {
        this.valueAttributeName = Optional.ofNullable(valueAttributeName);
    }

    public void setValueAttributePrefix(String valueAttributePrefix) {
        this.valueAttributePrefix = Optional.ofNullable(valueAttributePrefix);
    }

    public void setTypeAlias(String typeAlias) {
        this.typeAlias = Optional.ofNullable(typeAlias);
    }

    public void setTypeConverter(TypeConverter<? super String, ?> typeConverter) {
        this.typeConverter = typeConverter;
    }

    public TypeConverter<? super String, ?> getTypeConverter() {
        return this.typeConverter;
    }

    public void setDefaultVal(String defaultVal) {
        this.defaultVal = Optional.ofNullable(defaultVal);
    }

    public boolean isBeanWiring() {
        return this.isBeanWiring;
    }

    @PostConstruct
    public void postConstruct() throws SmooksConfigException {
        this.buildId();
        this.beanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo(this.beanIdName, this.appContext);
        this.isBeanWiring = this.wireBeanIdName.isPresent() || this.wireBeanType.isPresent() || this.wireBeanAnnotation.isPresent();
        this.isAttribute = this.valueAttributeName.isPresent();
        if (this.valueAttributePrefix.isPresent()) {
            Properties namespaces = (Properties)this.appContext.getRegistry().lookup((Function)new NamespaceManagerLookup());
            this.valueAttributeNS = namespaces.getProperty(this.valueAttributePrefix.get());
        }
        this.beanIdStore = this.appContext.getBeanIdStore();
        this.beanId = this.beanIdStore.getBeanId(this.beanIdName);
        if (!this.setterMethod.isPresent() && !this.property.isPresent()) {
            if (this.isBeanWiring && (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.NON_COLLECTION || this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.MAP_COLLECTION)) {
                this.property = Optional.of(this.wireBeanIdName.get());
            } else if (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.NON_COLLECTION) {
                throw new SmooksConfigException("Binding configuration for beanIdName='" + this.beanIdName + "' must contain either a 'property' or 'setterMethod' attribute definition, unless the target bean is a Collection/Array.  Bean is type '" + this.beanRuntimeInfo.getPopulateType().getName() + "'.");
            }
        }
        if (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.MAP_COLLECTION && this.property.isPresent()) {
            this.property = Optional.of(this.property.get().trim());
            if (this.property.get().length() > 1 && this.property.get().charAt(0) == '@') {
                this.mapKeyAttribute = this.property.get().substring(1);
            }
        }
        if (this.expression.isPresent()) {
            this.expression = Optional.of(this.expression.get().trim());
            this.expressionHasDataVariable = this.expression.get().contains(EXPRESSION_VALUE_VARIABLE_NAME);
            this.expression = Optional.of(this.expression.get().replace("this.", this.beanIdName + "."));
            if (this.expression.get().startsWith("+=")) {
                this.expression = Optional.of(this.beanIdName + "." + (String)this.property.orElse(null) + " +" + this.expression.get().substring(2));
            }
            if (this.expression.get().startsWith("-=")) {
                this.expression = Optional.of(this.beanIdName + "." + (String)this.property.orElse(null) + " -" + this.expression.get().substring(2));
            }
            this.expressionEvaluator = new MVELExpressionEvaluator();
            this.expressionEvaluator.setExpression(this.expression.get());
            Class<Object> bindingType = this.resolveBindTypeReflectively();
            if (bindingType != null) {
                if (this.typeAlias.isPresent()) {
                    bindingType = String.class;
                }
                this.expressionEvaluator.setToType(bindingType);
            }
        }
        if (this.wireBeanIdName.isPresent()) {
            this.wireBeanId = this.beanIdStore.getBeanId(this.wireBeanIdName.get());
            if (this.wireBeanId == null) {
                this.wireBeanId = this.beanIdStore.register(this.wireBeanIdName.get());
            }
        }
        if (this.isBeanWiring) {
            this.wireByBeanIdObserver = new BeanWiringObserver(this.beanId, this).watchedBeanId(this.wireBeanId).watchedBeanType(this.wireBeanType.orElse(null)).watchedBeanAnnotation(this.wireBeanAnnotation.orElse(null));
            if (this.wireBeanId != null) {
                this.listToArrayChangeObserver = new ListToArrayChangeObserver(this.wireBeanId, this.property.orElse(null), this);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Bean Instance Populator created for [" + this.beanIdName + "].  property=" + (String)this.property.orElse(null));
        }
    }

    private void buildId() {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(BeanInstancePopulator.class.getName());
        idBuilder.append("#");
        idBuilder.append(this.beanIdName);
        this.property.ifPresent(s -> idBuilder.append("#").append((String)s));
        this.setterMethod.ifPresent(s -> idBuilder.append("#").append((String)s).append("()"));
        this.wireBeanIdName.ifPresent(s -> idBuilder.append("#").append((String)s));
        this.id = idBuilder.toString();
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        if (!this.beanExists(executionContext)) {
            LOGGER.debug("Cannot bind data onto bean '" + this.beanId + "' as bean does not exist in BeanContext.");
            return;
        }
        if (this.isBeanWiring) {
            this.bindBeanValue(executionContext, (Fragment)new NodeFragment((Node)element));
        } else if (this.isAttribute) {
            this.bindSaxDataValue(element, executionContext);
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (!this.beanExists(executionContext)) {
            LOGGER.debug("Cannot bind data onto bean '" + this.beanId + "' as bean does not exist in BeanContext.");
            return;
        }
        if (!this.isBeanWiring && !this.isAttribute) {
            this.bindSaxDataValue(element, executionContext);
        }
    }

    private boolean beanExists(ExecutionContext executionContext) {
        return executionContext.getBeanContext().getBean(this.beanId) != null;
    }

    private void bindSaxDataValue(Element element, ExecutionContext executionContext) {
        String propertyName;
        if (this.mapKeyAttribute != null) {
            propertyName = DomUtils.getAttributeValue((Element)element, (String)this.mapKeyAttribute);
            if (propertyName == null) {
                propertyName = element.getLocalName();
            }
        } else {
            propertyName = this.property.orElseGet(element::getLocalName);
        }
        String dataString = null;
        if (this.expressionEvaluator == null || this.expressionHasDataVariable) {
            if (this.isAttribute) {
                dataString = DomUtils.getAttributeValue((Element)element, (String)this.valueAttributeName.orElse(null), (String)this.valueAttributeNS);
            } else {
                TextAccumulatorVisitorMemento textAccumulatorMemento = new TextAccumulatorVisitorMemento((Fragment)new NodeFragment((Node)element), (Visitor)this);
                executionContext.getMementoCaretaker().restore((Memento)textAccumulatorMemento);
                dataString = textAccumulatorMemento.getText();
            }
        }
        if (this.expressionEvaluator != null) {
            this.bindExpressionValue(propertyName, dataString, executionContext, (Fragment)new NodeFragment((Node)element));
        } else {
            this.decodeAndSetPropertyValue(propertyName, dataString, executionContext, (Fragment)new NodeFragment((Node)element));
        }
    }

    private void bindBeanValue(ExecutionContext executionContext, Fragment source) {
        BeanContext beanContext = executionContext.getBeanContext();
        Object bean = null;
        if (this.wireBeanId != null) {
            bean = beanContext.getBean(this.wireBeanId);
        }
        if (bean != null && !BeanWiringObserver.isMatchingBean(bean, this.wireBeanType.orElse(null), this.wireBeanAnnotation.orElse(null))) {
            bean = null;
        }
        if (bean == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registering bean ADD wiring observer for wiring bean '" + this.wireBeanId + "' onto target bean '" + this.beanId.getName() + "'.");
            }
            beanContext.addObserver((BeanContextLifecycleObserver)this.wireByBeanIdObserver);
        } else {
            this.populateAndSetPropertyValue(bean, beanContext, this.wireBeanId, executionContext, source);
        }
    }

    public void populateAndSetPropertyValue(Object bean, BeanContext beanContext, BeanId targetBeanId, ExecutionContext executionContext, Fragment source) {
        BeanRuntimeInfo wiredBeanRI = this.getWiredBeanRuntimeInfo();
        if (wiredBeanRI != null && wiredBeanRI.getClassification() == BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registering bean CHANGE wiring observer for wiring bean '" + targetBeanId + "' onto target bean '" + this.beanId.getName() + "' after it has been converted from a List to an array.");
            }
            beanContext.addObserver((BeanContextLifecycleObserver)this.listToArrayChangeObserver);
        } else {
            this.setPropertyValue(this.property.orElse(null), bean, executionContext, source);
        }
    }

    private void bindExpressionValue(String mapPropertyName, String dataString, ExecutionContext executionContext, Fragment source) {
        Map beanMap = executionContext.getBeanContext().getBeanMap();
        HashMap<String, String> variables = new HashMap<String, String>();
        if (this.expressionHasDataVariable) {
            variables.put(EXPRESSION_VALUE_VARIABLE_NAME, dataString);
        }
        Object dataObject = this.expressionEvaluator.exec((Object)beanMap, variables);
        this.decodeAndSetPropertyValue(mapPropertyName, dataObject, executionContext, source);
    }

    private void decodeAndSetPropertyValue(String mapPropertyName, Object dataObject, ExecutionContext executionContext, Fragment source) {
        if (dataObject instanceof String) {
            this.setPropertyValue(mapPropertyName, this.decodeDataString((String)dataObject, executionContext), executionContext, source);
        } else {
            this.setPropertyValue(mapPropertyName, dataObject, executionContext, source);
        }
    }

    public void setPropertyValue(String mapPropertyName, Object dataObject, ExecutionContext executionContext, Fragment source) {
        if (dataObject == null) {
            return;
        }
        Object bean = executionContext.getBeanContext().getBean(this.beanId);
        BeanRuntimeInfo.Classification beanType = this.beanRuntimeInfo.getClassification();
        this.createPropertySetterMethod(bean, dataObject.getClass());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting data object '" + (String)this.wireBeanIdName.orElse(null) + "' (" + dataObject.getClass().getName() + ") on target bean '" + this.beanId + "'.");
        }
        try {
            if (this.propertySetterMethod != null) {
                this.propertySetterMethod.invoke(bean, dataObject);
            } else if (beanType == BeanRuntimeInfo.Classification.MAP_COLLECTION) {
                ((Map)bean).put(mapPropertyName, dataObject);
            } else if (beanType == BeanRuntimeInfo.Classification.ARRAY_COLLECTION || beanType == BeanRuntimeInfo.Classification.COLLECTION_COLLECTION) {
                ((Collection)bean).add(dataObject);
            } else {
                if (this.setterMethod.isPresent()) {
                    throw new SmooksConfigException("Bean [" + this.beanIdName + "] configuration invalid.  Bean setter method [" + this.setterMethod.get() + "(" + dataObject.getClass().getName() + ")] not found on type [" + this.beanRuntimeInfo.getPopulateType().getName() + "].  You may need to set a 'decoder' on the binding config.");
                }
                if (this.property.isPresent()) {
                    boolean throwException = true;
                    if (this.beanRuntimeInfo.isJAXBType() && this.getWiredBeanRuntimeInfo().getClassification() != BeanRuntimeInfo.Classification.NON_COLLECTION && this.wireBeanId.getCreateResourceConfiguration().getParameter("beanFactory", String.class) != null) {
                        throwException = false;
                    }
                    if (throwException) {
                        throw new SmooksConfigException("Bean [" + this.beanIdName + "] configuration invalid.  Bean setter method [" + ClassUtil.toSetterName((String)this.property.get()) + "(" + dataObject.getClass().getName() + ")] not found on type [" + this.beanRuntimeInfo.getPopulateType().getName() + "].  You may need to set a 'decoder' on the binding config.");
                    }
                }
            }
            if (this.notifyPopulate.booleanValue()) {
                DefaultBeanContextLifecycleEvent event = new DefaultBeanContextLifecycleEvent(executionContext, source, BeanLifecycle.POPULATE, this.beanId, bean);
                executionContext.getBeanContext().notifyObservers((BeanContextLifecycleEvent)event);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new SmooksConfigException("Error invoking bean setter method [" + ClassUtil.toSetterName((String)this.property.orElse(null)) + "] on bean instance class type [" + bean.getClass() + "].", (Throwable)e);
        }
    }

    private void createPropertySetterMethod(Object bean, Class<?> parameter) {
        if (!this.checkedForSetterMethod && this.propertySetterMethod == null) {
            String methodName = null;
            if (this.setterMethod.isPresent() && !this.setterMethod.get().trim().equals("")) {
                methodName = this.setterMethod.get();
            } else if (this.property.isPresent() && !this.property.get().trim().equals("")) {
                methodName = ClassUtil.toSetterName((String)this.property.get());
            }
            if (methodName != null) {
                this.propertySetterMethod = this.createPropertySetterMethod(bean, methodName, parameter);
            }
            this.checkedForSetterMethod = true;
        }
    }

    private synchronized Method createPropertySetterMethod(Object bean, String setterName, Class<?> setterParamType) {
        if (this.propertySetterMethod == null) {
            this.propertySetterMethod = BeanUtils.createSetterMethod(setterName, bean, setterParamType);
        }
        return this.propertySetterMethod;
    }

    private Object decodeDataString(String dataString, ExecutionContext executionContext) throws TypeConverterException {
        if ((dataString == null || dataString.length() == 0) && this.defaultVal.isPresent()) {
            if (this.defaultVal.get().equals("null")) {
                return null;
            }
            dataString = this.defaultVal.get();
        }
        if (this.typeConverter == null) {
            this.typeConverter = this.getTypeConverter(executionContext);
        }
        try {
            return this.typeConverter.convert((Object)dataString);
        }
        catch (TypeConverterException e) {
            throw new TypeConverterException("Failed to decode binding value '" + dataString + "' for property '" + this.property + "' on bean '" + this.beanId.getName() + "'.", (Throwable)e);
        }
    }

    private TypeConverter<? super String, ?> getTypeConverter(ExecutionContext executionContext) throws TypeConverterException {
        return this.getTypeConverter(executionContext.getContentDeliveryRuntime().getContentDeliveryConfig());
    }

    public TypeConverter<? super String, ?> getTypeConverter(ContentDeliveryConfig deliveryConfig) {
        PreprocessTypeConverter preprocessTypeConverter;
        List typeConverters = deliveryConfig.getObjects("decoder:" + (String)this.typeAlias.orElse(null));
        if (typeConverters == null || typeConverters.isEmpty()) {
            this.typeConverter = this.typeAlias.isPresent() ? ((TypeConverterFactory)this.appContext.getRegistry().lookup((Function)new NameTypeConverterFactoryLookup(this.typeAlias.get()))).createTypeConverter() : this.resolveDecoderReflectively();
        } else {
            if (!(typeConverters.get(0) instanceof TypeConverter)) {
                throw new TypeConverterException("Configured type converter '" + (String)this.typeAlias.orElse(null) + ":" + typeConverters.get(0).getClass().getName() + "' is not an instance of " + TypeConverter.class.getName());
            }
            this.typeConverter = (TypeConverter)typeConverters.get(0);
        }
        if (this.typeConverter instanceof PreprocessTypeConverter && (preprocessTypeConverter = (PreprocessTypeConverter)this.typeConverter).getDelegateTypeConverter() == null) {
            preprocessTypeConverter.setDelegateTypeConverter(this.resolveDecoderReflectively());
        }
        return this.typeConverter;
    }

    private TypeConverter<? super String, ?> resolveDecoderReflectively() throws TypeConverterException {
        Class<?> bindType = this.resolveBindTypeReflectively();
        if (bindType != null) {
            if (bindType.isEnum()) {
                return value -> Enum.valueOf(bindType, value);
            }
            TypeConverterFactory typeConverterFactory = (TypeConverterFactory)this.appContext.getRegistry().lookup((Function)new SourceTargetTypeConverterFactoryLookup(String.class, bindType));
            if (typeConverterFactory != null) {
                return typeConverterFactory.createTypeConverter();
            }
        }
        return new StringConverterFactory().createTypeConverter();
    }

    private Class<?> resolveBindTypeReflectively() throws TypeConverterException {
        Method bindingMethod;
        String bindingMember = this.setterMethod.orElseGet(() -> this.property.orElse(null));
        if (bindingMember != null && this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.NON_COLLECTION && (bindingMethod = Bean.getBindingMethod(bindingMember, this.beanRuntimeInfo.getPopulateType())) != null) {
            return bindingMethod.getParameterTypes()[0];
        }
        return null;
    }

    private BeanRuntimeInfo getWiredBeanRuntimeInfo() {
        if (this.wiredBeanRuntimeInfo == null) {
            this.wiredBeanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo(this.wireBeanIdName.orElse(null), this.appContext);
        }
        return this.wiredBeanRuntimeInfo;
    }

    private String getId() {
        return this.id;
    }

    public Set<?> getProducts() {
        return Stream.of(this.beanIdName + "." + (String)this.property.orElse(null), "]." + (String)this.property.orElse(null)).collect(Collectors.toSet());
    }

    public boolean consumes(Object object) {
        if (object.equals(this.beanIdName)) {
            return true;
        }
        if (object.equals(this.wireBeanIdName.orElse(null))) {
            return true;
        }
        return this.expressionEvaluator != null && this.expressionEvaluator.getExpression().contains(object.toString());
    }

    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) throws SmooksException {
        if (!(this.isBeanWiring || this.isAttribute || this.expressionEvaluator != null && !this.expressionHasDataVariable)) {
            TextAccumulatorVisitorMemento textAccumulatorMemento = new TextAccumulatorVisitorMemento((Fragment)new NodeFragment(characterData.getParentNode()), (Visitor)this);
            executionContext.getMementoCaretaker().restore((Memento)textAccumulatorMemento);
            textAccumulatorMemento.accumulateText(characterData.getTextContent());
            executionContext.getMementoCaretaker().capture((Memento)textAccumulatorMemento);
        }
    }

    public void visitChildElement(Element childElement, ExecutionContext executionContext) throws SmooksException {
    }
}

