/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.engine.resource.extension.ExtensionContext;
import org.smooks.support.DollarBraceDecoder;
import org.smooks.support.DomUtils;
import org.w3c.dom.Element;

public class MapToSelectorFromContextAwareAttribute
implements DOMVisitBefore {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapToSelectorFromContextAwareAttribute.class);
    private static final Map<String, String> BASE_BEANS = new HashMap<String, String>();
    @Inject
    private String attribute;
    @Inject
    private ApplicationContext applicationContext;

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        String absoluteSelector;
        String foundBeanId;
        ResourceConfig resourceConfig;
        String value = DomUtils.getAttributeValue((Element)element, (String)this.attribute);
        try {
            resourceConfig = (ResourceConfig)((ExtensionContext)executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY)).getResourceStack().peek();
        }
        catch (EmptyStackException e) {
            throw new SmooksException("No ResourceConfig available in ExtensionContext stack.  Unable to set ResourceConfig property 'selector' with attribute '" + this.attribute + "' value '" + value + "'.");
        }
        if (value == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Not setting property 'selector' on resource configuration.  Attribute '" + this.attribute + "' value on element '" + DomUtils.getName((Element)element) + "' is null.  You may need to set a default value in the binding configuration.");
            }
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting property 'selector' on resource configuration to a value of '" + value + "'.");
        }
        if ((foundBeanId = DomUtils.getAttributeValue((Element)element, (String)"beanId")) != null) {
            BASE_BEANS.put(foundBeanId, DomUtils.getAttributeValue((Element)element, (String)"createOnElement"));
        }
        if (value.startsWith("#") && element.getParentNode() != null && element.getParentNode().getAttributes().getNamedItem("createOnElement") != null) {
            String contextSelector = element.getParentNode().getAttributes().getNamedItem("createOnElement").getNodeValue();
            absoluteSelector = contextSelector + value.substring(1);
        } else {
            absoluteSelector = value;
        }
        resourceConfig.setSelector(this.resolveBeandIdSelector(absoluteSelector), new Properties());
    }

    protected String resolveBeandIdSelector(String selector) {
        List dollarBraceTokens = DollarBraceDecoder.getTokens((String)selector.substring(0, selector.contains("/") ? selector.indexOf("/") : selector.length()));
        if (dollarBraceTokens.size() == 1) {
            String beanId = (String)dollarBraceTokens.get(0);
            String beanSelector = BASE_BEANS.get(beanId);
            if (beanSelector != null) {
                return this.resolveBeandIdSelector(beanSelector) + selector.substring(selector.indexOf("/"));
            }
            throw new SmooksConfigException("Invalid selector '" + selector + "'.  Unknown beanId '" + beanId + "'.");
        }
        return selector;
    }
}

