/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.binding.model.get;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.javabean.binding.BeanSerializationException;
import org.smooks.cartridges.javabean.binding.SerializationContext;
import org.smooks.cartridges.javabean.binding.model.Bean;
import org.smooks.cartridges.javabean.binding.model.Binding;
import org.smooks.cartridges.javabean.binding.model.DataBinding;
import org.smooks.cartridges.javabean.binding.model.get.BeanGetter;
import org.smooks.cartridges.javabean.binding.model.get.Getter;
import org.smooks.cartridges.javabean.binding.model.get.MapGetter;

public class GetterGraph<T>
implements Getter<T> {
    private String contextObjectName = SerializationContext.ROOT_OBJ;
    private List<Getter> graph = new ArrayList<Getter>();

    @Override
    public Object get(T contextObject) throws BeanSerializationException {
        AssertArgument.isNotNull(contextObject, (String)"contextObject");
        Object value = contextObject;
        for (Getter getter : this.graph) {
            value = getter.get(value);
            if (value != null) continue;
            return null;
        }
        return value;
    }

    private GetterGraph add(Getter getter) {
        this.graph.add(0, getter);
        return this;
    }

    public void add(DataBinding binding) {
        this.add(this.toGetter(binding.getParentBean(), binding));
    }

    public GetterGraph add(Bean bean, String property) {
        AssertArgument.isNotNull((Object)bean, (String)"bean");
        AssertArgument.isNotNullAndNotEmpty((String)property, (String)"property");
        Getter getter = null;
        for (Binding binding : bean.getBindings()) {
            if (!property.equals(binding.getProperty())) continue;
            getter = this.toGetter(bean, binding);
            break;
        }
        if (getter == null) {
            throw new IllegalStateException("Failed to create Getter instance for property '" + property + "' on bean type '" + bean.getBeanClass().getName() + "'.");
        }
        this.add(getter);
        return this;
    }

    private Getter toGetter(Bean bean, Binding binding) {
        if (Map.class.isAssignableFrom(bean.getBeanClass())) {
            return new MapGetter(binding.getProperty());
        }
        return new BeanGetter(bean.getBeanClass(), binding.getProperty());
    }

    public String getContextObjectName() {
        return this.contextObjectName;
    }

    public void setContextObjectName(String contextObjectName) {
        this.contextObjectName = contextObjectName;
    }
}

