/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.binding.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.smooks.Smooks;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.api.resource.config.xpath.SelectorPath;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.javabean.BeanInstanceCreator;
import org.smooks.cartridges.javabean.BeanInstancePopulator;
import org.smooks.cartridges.javabean.binding.AbstractBinding;
import org.smooks.cartridges.javabean.binding.BeanSerializationException;
import org.smooks.cartridges.javabean.binding.SerializationContext;
import org.smooks.cartridges.javabean.binding.model.Bean;
import org.smooks.cartridges.javabean.binding.model.Binding;
import org.smooks.cartridges.javabean.binding.model.DataBinding;
import org.smooks.cartridges.javabean.binding.model.ModelSet;
import org.smooks.cartridges.javabean.binding.model.WiredBinding;
import org.smooks.cartridges.javabean.binding.model.get.ConstantGetter;
import org.smooks.cartridges.javabean.binding.model.get.GetterGraph;
import org.smooks.cartridges.javabean.binding.xml.XMLAttributeSerializationNode;
import org.smooks.cartridges.javabean.binding.xml.XMLElementSerializationNode;
import org.smooks.cartridges.javabean.binding.xml.XMLSerializationNode;
import org.smooks.engine.lookup.ContentHandlerFactoryLookup;
import org.smooks.engine.lookup.NamespaceManagerLookup;
import org.smooks.engine.lookup.converter.SourceTargetTypeConverterFactoryLookup;
import org.smooks.engine.resource.config.xpath.step.AttributeSelectorStep;
import org.smooks.engine.resource.config.xpath.step.ElementSelectorStep;
import org.smooks.io.payload.StringSource;
import org.smooks.support.ClassUtil;
import org.xml.sax.SAXException;

public class XMLBinding
extends AbstractBinding {
    private ModelSet beanModelSet;
    private List<XMLElementSerializationNode> graphs;
    private final Set<QName> rootElementNames = new HashSet<QName>();
    private final Map<Class, RootNodeSerializer> serializers = new LinkedHashMap<Class, RootNodeSerializer>();
    private boolean omitXMLDeclaration = false;

    public XMLBinding() {
    }

    public XMLBinding(Smooks smooks) {
        super(smooks);
    }

    @Override
    public XMLBinding add(String smooksConfigURI) throws IOException, SAXException {
        super.add(smooksConfigURI);
        return this;
    }

    @Override
    public XMLBinding add(InputStream smooksConfigStream) throws IOException, SAXException {
        return (XMLBinding)super.add(smooksConfigStream);
    }

    @Override
    public XMLBinding setReportPath(String reportPath) {
        super.setReportPath(reportPath);
        return this;
    }

    @Override
    public XMLBinding initialise() {
        super.initialise();
        this.beanModelSet = ModelSet.get(this.getSmooks().getApplicationContext());
        this.graphs = this.createExpandedXMLOutputGraphs(this.getUserDefinedResourceList());
        this.createRootSerializers(this.graphs);
        this.mergeBeanModelsIntoXMLGraphs();
        return this;
    }

    public XMLBinding setOmitXMLDeclaration(boolean omitXMLDeclaration) {
        this.omitXMLDeclaration = omitXMLDeclaration;
        return this;
    }

    public <T> T fromXML(String inputSource, Class<T> toType) {
        try {
            return this.bind((Source)new StringSource(inputSource), toType);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException from a String input.", e);
        }
    }

    public <T> T fromXML(Source inputSource, Class<T> toType) throws IOException {
        return this.bind(inputSource, toType);
    }

    public <W extends Writer> W toXML(Object object, W outputWriter) throws BeanSerializationException, IOException {
        AssertArgument.isNotNull((Object)object, (String)"object");
        this.assertInitialized();
        Class<?> objectClass = object.getClass();
        RootNodeSerializer rootNodeSerializer = this.serializers.get(objectClass);
        if (rootNodeSerializer == null) {
            throw new BeanSerializationException("No serializer for Java type '" + objectClass.getName() + "'.");
        }
        if (!this.omitXMLDeclaration) {
            outputWriter.write("<?xml version=\"1.0\"?>\n");
        }
        XMLElementSerializationNode serializer = rootNodeSerializer.serializer;
        serializer.serialize(outputWriter, new SerializationContext(object, rootNodeSerializer.beanId));
        outputWriter.flush();
        return outputWriter;
    }

    public String toXML(Object object) throws BeanSerializationException {
        StringWriter writer = new StringWriter();
        try {
            this.toXML(object, writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException writing to a StringWriter.", e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unexpected IOException closing a StringWriter.", e);
            }
        }
    }

    private void mergeBeanModelsIntoXMLGraphs() {
        Set<Map.Entry<Class, RootNodeSerializer>> serializerSet = this.serializers.entrySet();
        for (Map.Entry<Class, RootNodeSerializer> rootNodeSerializer : serializerSet) {
            Bean model = this.beanModelSet.getModel(rootNodeSerializer.getKey());
            if (model == null) {
                throw new IllegalStateException("Unexpected error.  No Bean model for type '" + rootNodeSerializer.getKey().getName() + "'.");
            }
            this.merge(rootNodeSerializer.getValue().serializer, model);
        }
    }

    private void merge(XMLElementSerializationNode serializer, Bean bean) {
        boolean isCollection = bean.isCollection();
        for (Binding binding : bean.getBindings()) {
            BeanInstancePopulator populator = binding.getPopulator();
            if (!isCollection && binding instanceof DataBinding) {
                XMLSerializationNode node = serializer.findNode(populator.getConfig().getSelectorPath());
                if (node == null) continue;
                node.setGetter(this.constructContextualGetter((DataBinding)binding));
                Method getterMethodByProperty = ClassUtil.getGetterMethodByProperty((String)binding.getProperty(), bean.getBeanClass(), null);
                TypeConverter<? super String, ?> beanPopulatorTypeConverter = binding.getPopulator().getTypeConverter(this.getSmooks().createExecutionContext().getContentDeliveryRuntime().getContentDeliveryConfig());
                TypeConverterFactory xmlBindingTypeFactory = (TypeConverterFactory)this.getSmooks().getApplicationContext().getRegistry().lookup((Function)new SourceTargetTypeConverterFactoryLookup(getterMethodByProperty.getReturnType(), String.class));
                if (xmlBindingTypeFactory == null) continue;
                TypeConverter xmlBindingTypeConverter = xmlBindingTypeFactory.createTypeConverter();
                if (xmlBindingTypeConverter instanceof Configurable && beanPopulatorTypeConverter instanceof Configurable) {
                    ((Configurable)xmlBindingTypeConverter).setConfiguration(((Configurable)beanPopulatorTypeConverter).getConfiguration());
                }
                node.setTypeConverter(xmlBindingTypeConverter);
                continue;
            }
            if (!(binding instanceof WiredBinding)) continue;
            Bean wiredBean = ((WiredBinding)binding).getWiredBean();
            XMLElementSerializationNode node = (XMLElementSerializationNode)serializer.findNode(wiredBean.getCreator().getConfig().getSelectorPath());
            if (node != null) {
                if (isCollection) {
                    Bean collectionBean = wiredBean.getWiredInto();
                    GetterGraph getter = this.constructContextualGetter(collectionBean);
                    node.setIsCollection(true);
                    node.setCollectionGetter(wiredBean.getBeanId(), getter);
                } else {
                    node.setGetter(this.constructContextualGetter(wiredBean));
                }
            }
            this.merge(serializer, wiredBean);
        }
    }

    private void createRootSerializers(List<XMLElementSerializationNode> graphs) {
        Collection<Bean> beanModels = this.beanModelSet.getModels().values();
        for (Bean model : beanModels) {
            BeanInstanceCreator creator = model.getCreator();
            SelectorPath selectorPath = creator.getConfig().getSelectorPath();
            XMLElementSerializationNode createNode = (XMLElementSerializationNode)this.findNode(graphs, selectorPath);
            if (!this.rootElementNames.contains(createNode.getQName())) continue;
            createNode = (XMLElementSerializationNode)createNode.clone();
            createNode.setParent(null);
            Class<?> beanClass = creator.getBeanRuntimeInfo().getPopulateType();
            if (Collection.class.isAssignableFrom(beanClass)) continue;
            this.serializers.put(beanClass, new RootNodeSerializer(creator.getBeanId(), createNode));
            this.addNamespaceAttributes(createNode);
        }
    }

    private void addNamespaceAttributes(XMLElementSerializationNode serializer) {
        Properties namespaces = (Properties)this.getSmooks().getApplicationContext().getRegistry().lookup((Function)new NamespaceManagerLookup());
        if (namespaces != null) {
            Enumeration<?> namespacePrefixes = namespaces.propertyNames();
            while (namespacePrefixes.hasMoreElements()) {
                String prefix = (String)namespacePrefixes.nextElement();
                String namespace = namespaces.getProperty(prefix);
                QName nsAttributeName = new QName("http://www.w3.org/2000/xmlns/", prefix, "xmlns");
                XMLAttributeSerializationNode nsAttribute = new XMLAttributeSerializationNode(nsAttributeName);
                serializer.getAttributes().add(nsAttribute);
                nsAttribute.setGetter(new ConstantGetter(namespace));
            }
        }
    }

    private List<XMLElementSerializationNode> createExpandedXMLOutputGraphs(ResourceConfigSeq resourceConfigSeq) {
        ArrayList<XMLElementSerializationNode> graphRoots = new ArrayList<XMLElementSerializationNode>();
        for (int i = 0; i < resourceConfigSeq.size(); ++i) {
            ResourceConfig resourceConfig = resourceConfigSeq.get(i);
            Object javaResource = resourceConfig.isJavaResource() ? ((ContentHandlerFactory)this.getSmooks().getApplicationContext().getRegistry().lookup((Function)new ContentHandlerFactoryLookup("class"))).create(resourceConfig) : null;
            if (javaResource instanceof BeanInstanceCreator) {
                this.assertSelectorOK(resourceConfig);
                this.constructNodePath(resourceConfig.getSelectorPath(), graphRoots);
                continue;
            }
            if (!(javaResource instanceof BeanInstancePopulator)) continue;
            this.assertSelectorOK(resourceConfig);
            this.constructNodePath(resourceConfig.getSelectorPath(), graphRoots);
        }
        return graphRoots;
    }

    private XMLSerializationNode constructNodePath(SelectorPath selectorPath, List<XMLElementSerializationNode> graphRoots) {
        if (selectorPath == null || selectorPath.size() == 0) {
            throw new IllegalStateException("Invalid binding configuration.  All <jb:bean> configuration elements must specify fully qualified selector paths (createOnElement, data, executeOnElement attributes etc.).");
        }
        SelectorStep rootSelectorStep = (SelectorStep)selectorPath.get(1);
        XMLElementSerializationNode root = XMLElementSerializationNode.getElement(rootSelectorStep, graphRoots, true);
        if (selectorPath.size() == 3 && selectorPath.get(2) instanceof AttributeSelectorStep) {
            return XMLElementSerializationNode.addAttributeNode(root, (SelectorStep)selectorPath.get(2), true);
        }
        if (selectorPath.size() > 2) {
            return root.getPathNode(selectorPath, 2, true);
        }
        return root;
    }

    private XMLSerializationNode findNode(List<XMLElementSerializationNode> graphs, SelectorPath selectorPath) {
        XMLElementSerializationNode root;
        XMLSerializationNode node = root = XMLElementSerializationNode.getElement((SelectorStep)selectorPath.get(1), graphs, false);
        if (selectorPath.size() > 2) {
            node = root.getPathNode(selectorPath, 2, false);
        }
        if (node == null) {
            throw new IllegalStateException("Unexpected exception.  Failed to locate the node '" + selectorPath + "'.");
        }
        return node;
    }

    private void assertSelectorOK(ResourceConfig resourceConfig) {
        String selector = resourceConfig.getSelectorPath().getSelector();
        if (selector != null) {
            if (selector.contains("#document")) {
                throw new SmooksConfigException("Cannot use the document selector with the XMLBinding class.  Must use an absolute path.  Selector value '" + selector + "'.");
            }
            if (!(selector.startsWith("/") || selector.startsWith(" ${") || selector.startsWith("#"))) {
                throw new SmooksConfigException("Invalid selector value '" + selector + "'.  Selector paths must be absolute.");
            }
            this.rootElementNames.add(((ElementSelectorStep)resourceConfig.getSelectorPath().get(1)).getQName());
        }
    }

    private static class RootNodeSerializer {
        private final String beanId;
        private final XMLElementSerializationNode serializer;

        private RootNodeSerializer(String beanId, XMLElementSerializationNode serializer) {
            this.beanId = beanId;
            this.serializer = serializer;
        }
    }
}

