/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.dynamic;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.FilterSettings;
import org.smooks.Smooks;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleEvent;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleObserver;
import org.smooks.api.bean.lifecycle.BeanLifecycle;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.javabean.dynamic.BeanMetadata;
import org.smooks.cartridges.javabean.dynamic.BeanRegistrationException;
import org.smooks.cartridges.javabean.dynamic.Descriptor;
import org.smooks.cartridges.javabean.dynamic.Model;
import org.smooks.cartridges.javabean.dynamic.serialize.BeanWriter;
import org.smooks.cartridges.javabean.dynamic.visitor.NamespaceReaper;
import org.smooks.cartridges.javabean.dynamic.visitor.UnknownElementDataReaper;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.report.HtmlReportGenerator;
import org.smooks.engine.resource.config.ParameterAccessor;
import org.smooks.io.payload.JavaResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModelBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelBuilder.class);
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private final Descriptor descriptor;
    private boolean validate;
    private String reportPath;

    public ModelBuilder(Descriptor descriptor, boolean validate) throws SAXException, IOException {
        AssertArgument.isNotNull((Object)descriptor, (String)"descriptor");
        this.descriptor = descriptor;
        this.validate = validate;
        this.configure();
    }

    public ModelBuilder(String descriptorPath, boolean validate) throws SAXException, IOException {
        AssertArgument.isNotNullAndNotEmpty((String)descriptorPath, (String)"descriptorPath");
        this.descriptor = new Descriptor(descriptorPath);
        this.validate = validate;
        this.configure();
    }

    public boolean isValidating() {
        return this.validate;
    }

    protected Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    public <T> T readObject(InputStream message, Class<T> returnType) throws SAXException, IOException {
        return this.readObject(new InputStreamReader(message), returnType);
    }

    public <T> T readObject(Reader message, Class<T> returnType) throws SAXException, IOException {
        Model<JavaResult> model = this.readModel(message, JavaResult.class);
        return (T)model.getModelRoot().getBean(returnType);
    }

    public <T> Model<T> readModel(InputStream message, Class<T> modelRoot) throws SAXException, IOException {
        return this.readModel(new InputStreamReader(message), modelRoot);
    }

    public <T> Model<T> readModel(Reader message, Class<T> modelRoot) throws SAXException, IOException {
        AssertArgument.isNotNull((Object)message, (String)"message");
        AssertArgument.isNotNull(modelRoot, (String)"modelRoot");
        JavaResult result = new JavaResult();
        ExecutionContext executionContext = this.descriptor.getSmooks().createExecutionContext();
        Map<Class<?>, Map<String, BeanWriter>> beanWriters = this.descriptor.getBeanWriters();
        BeanTracker beanTracker = new BeanTracker(beanWriters);
        if (this.reportPath != null) {
            executionContext.getContentDeliveryRuntime().getExecutionEventListeners().add(new HtmlReportGenerator(this.reportPath));
        }
        executionContext.getBeanContext().addObserver((BeanContextLifecycleObserver)beanTracker);
        if (this.validate && this.descriptor.getSchema() != null) {
            Document messageDoc = this.toDocument(message);
            this.descriptor.getSchema().newValidator().validate(new DOMSource(messageDoc));
            this.descriptor.getSmooks().filterSource(executionContext, (Source)new DOMSource(messageDoc), new Result[]{result});
        } else {
            this.descriptor.getSmooks().filterSource(executionContext, (Source)new StreamSource(message), new Result[]{result});
        }
        Model<T> model = modelRoot == JavaResult.class ? new Model<T>(modelRoot.cast(result), beanTracker.beans, beanWriters, NamespaceReaper.getNamespacePrefixMappings(executionContext)) : new Model<T>(modelRoot.cast(result.getBean(modelRoot)), beanTracker.beans, beanWriters, NamespaceReaper.getNamespacePrefixMappings(executionContext));
        return model;
    }

    private Document toDocument(Reader message) {
        DocumentBuilder docBuilder;
        try {
            docBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SmooksException("Unable to parse message and dynamically bind into object model.  DOM Parser confguration exception.", (Throwable)e);
        }
        try {
            Document e = docBuilder.parse(new InputSource(message));
            return e;
        }
        catch (SAXException e) {
            throw new SmooksException("Unable to parse message and dynamically bind into object model.  Message format exception.", (Throwable)e);
        }
        catch (IOException e) {
            throw new SmooksException("Unable to parse message and dynamically bind into object model.  IO exception.", (Throwable)e);
        }
        finally {
            try {
                message.close();
            }
            catch (IOException e) {
                LOGGER.debug("Exception closing message reader.", (Throwable)e);
            }
        }
    }

    private void configure() {
        Smooks smooks = this.descriptor.getSmooks();
        smooks.addVisitor((Visitor)new NamespaceReaper());
        smooks.setFilterSettings(FilterSettings.newSaxNgSettings().setMaxNodeDepth(Integer.MAX_VALUE));
        ParameterAccessor.setParameter((String)"org.smooks.cartridges.javabean.notify.populate", (Object)"true", (Smooks)smooks);
        smooks.createExecutionContext();
    }

    static {
        DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
    }

    private static class BeanTracker
    implements BeanContextLifecycleObserver {
        private final List<BeanMetadata> beans = new ArrayList<BeanMetadata>();
        private final Map<Class<?>, Map<String, BeanWriter>> beanWriterMap;

        public BeanTracker(Map<Class<?>, Map<String, BeanWriter>> beanWriterMap) {
            this.beanWriterMap = beanWriterMap;
        }

        public void onBeanLifecycleEvent(BeanContextLifecycleEvent event) {
            if (event.getLifecycle() == BeanLifecycle.ADD || event.getLifecycle() == BeanLifecycle.CHANGE) {
                Object bean = event.getBean();
                BeanMetadata beanMetadata = new BeanMetadata(bean);
                Map<String, BeanWriter> beanWriters = this.beanWriterMap.get(bean.getClass());
                Fragment source = event.getSource();
                if (source != null) {
                    String namespaceURI = null;
                    if (source instanceof NodeFragment) {
                        Node node = (Node)source.unwrap();
                        namespaceURI = node.getNamespaceURI();
                        beanMetadata.setNamespace(namespaceURI);
                        beanMetadata.setNamespacePrefix(node.getPrefix());
                        beanMetadata.setCreateSource(source);
                        this.beans.add(beanMetadata);
                        beanMetadata.setPreText(UnknownElementDataReaper.getPreText((Element)node, this.beans));
                    }
                    if (beanWriters != null) {
                        BeanWriter beanWriter = beanWriters.get(namespaceURI);
                        if (beanWriter != null) {
                            beanMetadata.setWriter(beanWriter);
                        } else if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("BeanWriters are configured for Object type '" + bean.getClass() + "', but not for namespace '" + namespaceURI + "'.");
                        }
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("No BeanWriters configured for Object type '" + bean.getClass() + "'.");
                    }
                }
            } else if (event.getLifecycle() == BeanLifecycle.POPULATE) {
                BeanMetadata beanMetdata = this.findMetadata(event.getBean());
                beanMetdata.getPopulateSources().add(event.getSource());
            }
        }

        private BeanMetadata findMetadata(Object bean) {
            for (BeanMetadata metaData : this.beans) {
                if (metaData.getBean() != bean) continue;
                return metaData;
            }
            BeanRegistrationException.throwUnregisteredBeanInstanceException(bean);
            return null;
        }
    }
}

