/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.dynamic.ext;

import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.cartridges.javabean.dynamic.serialize.BeanWriter;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;

public class BeanWriterFactory
implements ContentHandler {
    @Inject
    private String beanId;
    @Inject
    @Named(value="class")
    private Class<? extends BeanWriter> beanWriterClass;
    @Inject
    @Named(value="beanClass")
    private Class<?> beanClass;
    @Inject
    private ResourceConfig resourceConfig;
    @Inject
    private ApplicationContext appContext;

    @PostConstruct
    public void createBeanWriter() {
        try {
            BeanWriter beanWriter = this.beanWriterClass.newInstance();
            ((LifecycleManager)this.appContext.getRegistry().lookup((Function)new LifecycleManagerLookup())).applyPhase((Object)beanWriter, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.appContext.getRegistry(), this.resourceConfig, (Object)beanWriter)));
            BeanWriterFactory.getBeanWriters(this.beanClass, this.appContext).put(this.resourceConfig.getSelectorPath().getSelectorNamespaceURI(), beanWriter);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SmooksConfigException("Unable to create BeanWriter instance.", (Throwable)e);
        }
    }

    public static Map<String, BeanWriter> getBeanWriters(Class<?> beanClass, ApplicationContext appContext) {
        Map<Class<?>, Map<String, BeanWriter>> beanWriterMap = BeanWriterFactory.getBeanWriters(appContext);
        Map beanWriters = beanWriterMap.computeIfAbsent(beanClass, k -> new LinkedHashMap());
        return beanWriters;
    }

    public static Map<Class<?>, Map<String, BeanWriter>> getBeanWriters(ApplicationContext appContext) {
        HashMap beanWriters = (HashMap)appContext.getRegistry().lookup(BeanWriter.class);
        if (beanWriters == null) {
            beanWriters = new HashMap();
            appContext.getRegistry().registerObject(BeanWriter.class, beanWriters);
        }
        return beanWriters;
    }
}

