/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.dynamic.serialize.freemarker;

import freemarker.template.Configuration;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.cartridges.javabean.dynamic.BeanMetadata;
import org.smooks.cartridges.javabean.dynamic.BeanRegistrationException;
import org.smooks.cartridges.javabean.dynamic.Model;
import org.smooks.cartridges.javabean.dynamic.serialize.BeanWriter;
import org.smooks.cartridges.javabean.dynamic.serialize.freemarker.WriteAttribsDirective;
import org.smooks.cartridges.javabean.dynamic.serialize.freemarker.WriteBeanDirective;
import org.smooks.cartridges.javabean.dynamic.serialize.freemarker.WriteBeanPreTextDirective;
import org.smooks.cartridges.javabean.dynamic.serialize.freemarker.WriteNamespacesDirective;
import org.smooks.support.FreeMarkerTemplate;

public class FreeMarkerBeanWriter
implements BeanWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FreeMarkerBeanWriter.class);
    public static final String MODEL_CTX_KEY = "dyna_model_inst";
    @Inject
    private ApplicationContext appContext;
    @Inject
    @Named(value="template")
    private String templateConfig;
    private FreeMarkerTemplate template;
    private static final WriteNamespacesDirective writeNamespacesDirective = new WriteNamespacesDirective();
    private static final WriteBeanDirective writeBeanDirective = new WriteBeanDirective();
    private static final WriteBeanPreTextDirective writePreTextDirective = new WriteBeanPreTextDirective();
    private static final WriteAttribsDirective writeAttribsDirective = new WriteAttribsDirective();

    @PostConstruct
    public void postConstruct() {
        String trimmedTemplateConfig = this.templateConfig.trim();
        if (trimmedTemplateConfig.trim().indexOf(10) == -1) {
            try {
                InputStream templateStream = this.appContext.getResourceLocator().getResource(trimmedTemplateConfig);
                if (templateStream != null) {
                    templateStream.close();
                    Configuration ftlConfiguration = new Configuration(Configuration.VERSION_2_3_30);
                    ftlConfiguration.setClassLoaderForTemplateLoading(this.appContext.getClassLoader(), "/");
                    this.templateConfig = ftlConfiguration.getTemplate(trimmedTemplateConfig).toString();
                }
            }
            catch (IOException e) {
                LOGGER.debug("'template' configuration value '" + trimmedTemplateConfig + "' does not resolve to an external FreeMarker template.  Using configured value as the actual template.");
            }
        }
        this.template = new FreeMarkerTemplate(this.templateConfig);
    }

    @Override
    public void write(Object bean, Writer writer, Model model) throws BeanRegistrationException, IOException {
        HashMap<String, Object> templateContext = new HashMap<String, Object>();
        BeanMetadata beanMetadata = model.getBeanMetadata(bean);
        if (beanMetadata == null) {
            BeanRegistrationException.throwUnregisteredBeanInstanceException(bean);
        }
        templateContext.put("bean", bean);
        templateContext.put(MODEL_CTX_KEY, model);
        templateContext.put("nsp", beanMetadata.getNamespacePrefix());
        templateContext.put("writeNamespaces", writeNamespacesDirective);
        templateContext.put("writeBean", writeBeanDirective);
        templateContext.put("writePreText", writePreTextDirective);
        templateContext.put("writeAttribs", writeAttribsDirective);
        this.template.apply(templateContext, writer);
    }
}

