/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.dynamic.serialize.freemarker;

import freemarker.core.Environment;
import freemarker.ext.beans.BeanModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.smooks.cartridges.javabean.dynamic.Model;

class WriteNamespacesDirective
implements TemplateDirectiveModel {
    WriteNamespacesDirective() {
    }

    public void execute(Environment environment, Map params, TemplateModel[] templateModels, TemplateDirectiveBody templateDirectiveBody) throws TemplateException, IOException {
        Writer writer = environment.getOut();
        BeanModel modelBeanModel = (BeanModel)environment.getDataModel().get("dyna_model_inst");
        Model model = (Model)modelBeanModel.getWrappedObject();
        Map<String, String> namespaces = model.getNamespacePrefixMappings();
        Set<Map.Entry<String, String>> nsEntries = namespaces.entrySet();
        boolean addNewline = false;
        SimpleScalar indentScalar = (SimpleScalar)params.get("indent");
        int indent = 12;
        if (indentScalar != null) {
            String indentParamVal = indentScalar.getAsString().trim();
            try {
                indent = Integer.parseInt(indentParamVal);
                indent = Math.min(indent, 100);
            }
            catch (NumberFormatException e) {
                indent = 12;
            }
        }
        for (Map.Entry<String, String> nsEntry : nsEntries) {
            if (addNewline) {
                writer.write(10);
                for (int i = 0; i < indent; ++i) {
                    writer.write(32);
                }
            }
            String uri = nsEntry.getKey();
            String prefix = nsEntry.getValue();
            if (prefix == null || prefix.equals("") || prefix.equals("xmlns")) {
                writer.write("xmlns=");
            } else {
                writer.write("xmlns:" + prefix + "=");
            }
            writer.write(34);
            writer.write(uri);
            writer.write(34);
            addNewline = true;
        }
    }
}

