/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.dynamic.visitor;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.support.XmlUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class NamespaceReaper
implements BeforeVisitor {
    private static final TypedKey<Map<String, String>> NAMESPACE_REAPER_TYPED_KEY = new TypedKey();

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        Map<String, String> namespacePrefixMappings = NamespaceReaper.getNamespacePrefixMappings(executionContext);
        NamedNodeMap attributes = element.getAttributes();
        int attributeCount = attributes.getLength();
        for (int i = 0; i < attributeCount; ++i) {
            String uri;
            QName attrQName;
            Attr attr = (Attr)attributes.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || (attrQName = XmlUtil.toQName((String)(uri = attr.getValue()), (String)attr.getLocalName(), (String)attr.getNodeName())) == null) continue;
            this.addMapping(namespacePrefixMappings, uri, attrQName.getLocalPart());
        }
    }

    private void addMapping(Map<String, String> namespacePrefixMappings, String uri, String prefix) {
        if (uri != null && prefix != null && !namespacePrefixMappings.containsKey(uri)) {
            namespacePrefixMappings.put(uri, prefix);
        }
    }

    public static Map<String, String> getNamespacePrefixMappings(ExecutionContext executionContext) {
        LinkedHashMap namespacePrefixMappings = (LinkedHashMap)executionContext.get(NAMESPACE_REAPER_TYPED_KEY);
        if (namespacePrefixMappings == null) {
            namespacePrefixMappings = new LinkedHashMap();
            executionContext.put(NAMESPACE_REAPER_TYPED_KEY, namespacePrefixMappings);
        }
        return namespacePrefixMappings;
    }
}

