/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.smooks.api.ExecutionContext;
import org.smooks.cartridges.javabean.factory.AbstractCachingFactoryDefinitionParser;
import org.smooks.cartridges.javabean.factory.Alias;
import org.smooks.cartridges.javabean.factory.Factory;
import org.smooks.cartridges.javabean.factory.FactoryException;
import org.smooks.cartridges.javabean.factory.InvalidFactoryDefinitionException;
import org.smooks.support.ClassUtil;

@Alias(value={"basic"})
public class BasicFactoryDefinitionParser
extends AbstractCachingFactoryDefinitionParser {
    @Override
    protected Factory<?> createFactory(String factoryDefinition) {
        String[] defParts = factoryDefinition.split("#");
        if (defParts.length == 2) {
            String className = defParts[0];
            String methodDef = defParts[1];
            try {
                String[] methodParts = methodDef.split("\\.");
                if (methodParts.length == 1) {
                    return this.createStaticMethodFactory(factoryDefinition, className, methodDef);
                }
                if (methodParts.length == 2) {
                    String staticGetInstanceMethodDef = methodParts[0];
                    String factoryMethodDef = methodParts[1];
                    return this.createFactoryInstanceFactory(factoryDefinition, className, staticGetInstanceMethodDef, factoryMethodDef);
                }
                throw this.createInvalidDefinitionException(factoryDefinition);
            }
            catch (InvalidFactoryDefinitionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FactoryException("The factory could not be created from the definition '" + factoryDefinition + "'.", e);
            }
        }
        throw this.createInvalidDefinitionException(factoryDefinition);
    }

    private Factory<?> createStaticMethodFactory(String factoryDefinition, String className, String methodDef) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Class factoryClass = ClassUtil.forName((String)className, this.getClass());
        Method factoryMethod = factoryClass.getMethod(methodDef, new Class[0]);
        if (!Modifier.isStatic(factoryMethod.getModifiers())) {
            throw new NoSuchMethodException("No static method with the name '" + methodDef + "' can be found on the class '" + className + "' while processing the factory definition '" + factoryDefinition + "'.");
        }
        return new StaticMethodFactory(factoryDefinition, factoryMethod);
    }

    private Factory<?> createFactoryInstanceFactory(String factoryDefinition, String className, String staticGetInstanceMethodDef, String factoryMethodDef) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Class factoryClass = ClassUtil.forName((String)className, this.getClass());
        Method getInstanceMethod = factoryClass.getMethod(staticGetInstanceMethodDef, new Class[0]);
        Class<?> factoryType = getInstanceMethod.getReturnType();
        Method factoryMethod = factoryType.getMethod(factoryMethodDef, new Class[0]);
        if (!Modifier.isStatic(getInstanceMethod.getModifiers())) {
            throw new NoSuchMethodException("No static method with the name '" + staticGetInstanceMethodDef + "' can be found on the class '" + className + "'.");
        }
        return new FactoryInstanceFactory(factoryDefinition, getInstanceMethod, factoryMethod);
    }

    private InvalidFactoryDefinitionException createInvalidDefinitionException(String factoryDefinition) {
        return new InvalidFactoryDefinitionException("The factory definition '" + factoryDefinition + "' isn't valid. The definition is 'some.package.SomeFactory#createObject' or 'some.package.SomeFactorySingleton#getFactoryMethod.createObject'");
    }

    private static String toClassDefinition(Method method) {
        return method.getDeclaringClass().getName() + "#" + method.getName() + "()";
    }

    private static class FactoryInstanceFactory
    implements Factory<Object> {
        private final String factoryDefinition;
        private final Method getInstanceMethod;
        private final Method factoryMethod;

        public FactoryInstanceFactory(String factoryDefinition, Method getInstanceMethod, Method factoryMethod) {
            this.factoryDefinition = factoryDefinition;
            this.getInstanceMethod = getInstanceMethod;
            this.factoryMethod = factoryMethod;
        }

        @Override
        public Object create(ExecutionContext executionContext) {
            Object factoryObj;
            try {
                factoryObj = this.getInstanceMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new FactoryException("Could not invoke the static method '" + BasicFactoryDefinitionParser.toClassDefinition(this.getInstanceMethod) + "' to retrieve the factory defined by the factory definition '" + this.factoryDefinition + "'");
            }
            if (factoryObj == null) {
                throw new NullPointerException("The static method '" + BasicFactoryDefinitionParser.toClassDefinition(this.getInstanceMethod) + "' returned null, which is not allowed");
            }
            try {
                return this.factoryMethod.invoke(factoryObj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new FactoryException("Could not invoke the method '" + BasicFactoryDefinitionParser.toClassDefinition(this.factoryMethod) + "' on the factory object '" + factoryObj + "'. This factory is defined by the factory definition '" + this.factoryDefinition + "'");
            }
        }

        public String toString() {
            return String.format("%s[factoryDefinition=%s,factoryMethod=%s]", this, this.factoryDefinition, this.factoryMethod);
        }
    }

    private static class StaticMethodFactory
    implements Factory<Object> {
        private final String factoryDefinition;
        private final Method factoryMethod;

        public StaticMethodFactory(String factoryDefinition, Method factoryMethod) {
            this.factoryDefinition = factoryDefinition;
            this.factoryMethod = factoryMethod;
        }

        @Override
        public Object create(ExecutionContext executionContext) {
            try {
                return this.factoryMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new FactoryException("Could not invoke the static factory method '" + BasicFactoryDefinitionParser.toClassDefinition(this.factoryMethod) + "' defined by the factory definition '" + this.factoryDefinition + "'");
            }
        }

        public String toString() {
            return String.format("%s[factoryDefinition=%s,factoryMethod=%s]", this, this.factoryDefinition, this.factoryMethod);
        }
    }
}

