/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.lifecycle;

import jakarta.annotation.PostConstruct;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.smooks.api.ExecutionContext;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.lifecycle.ExecutionLifecycleCleanable;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.w3c.dom.Element;

public class BeanResultCleanup
implements ExecutionLifecycleCleanable,
BeforeVisitor {
    @Inject
    private String[] beanIDs;
    private Set<String> beanIDSet;

    @PostConstruct
    public void postConstruct() {
        this.beanIDSet = Stream.of(this.beanIDs).collect(Collectors.toSet());
    }

    public void executeExecutionLifecycleCleanup(ExecutionContext executionContext) {
        BeanContext beanContext = executionContext.getBeanContext();
        Set beanSet = beanContext.getBeanMap().entrySet();
        for (Map.Entry beanEntry : beanSet) {
            String beanID = (String)beanEntry.getKey();
            if (this.beanIDSet.contains(beanID)) continue;
            beanContext.removeBean(beanID, null);
        }
    }

    public void visitBefore(Element element, ExecutionContext executionContext) {
    }
}

