/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.context;

import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.bean.repository.BeanId;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.sax.ng.ElementVisitor;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StaticVariableBinder
implements ElementVisitor {
    protected static final String STATVAR = "statvar";
    protected BeanId beanId;
    @Inject
    protected ResourceConfig resourceConfig;
    @Inject
    protected ApplicationContext appContext;

    @PostConstruct
    public void postConstruct() throws SmooksConfigException {
        this.beanId = this.appContext.getBeanIdStore().getBeanId(STATVAR);
        if (this.beanId == null) {
            this.beanId = this.appContext.getBeanIdStore().register(STATVAR);
        }
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.bindParamaters(executionContext, (Fragment<?>)new NodeFragment((Node)element));
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
    }

    protected void bindParamaters(ExecutionContext executionContext, Fragment<?> source) {
        List params = this.resourceConfig.getParameterValues();
        for (Object parameter : params) {
            if (parameter instanceof List) {
                this.bindParameter((Parameter)((List)parameter).get(0), executionContext, source);
                continue;
            }
            if (!(parameter instanceof Parameter)) continue;
            this.bindParameter((Parameter)parameter, executionContext, source);
        }
    }

    protected void bindParameter(Parameter<?> parameter, ExecutionContext executionContext, Fragment<?> source) {
        HashMap<String, Object> params = null;
        BeanContext beanContext = executionContext.getBeanContext();
        try {
            HashMap<String, Object> castParams;
            params = castParams = (HashMap<String, Object>)beanContext.getBean(this.beanId);
        }
        catch (ClassCastException e) {
            throw new SmooksException("Illegal use of reserved beanId 'statvar'.  Must be a Map.  Is a " + params.getClass().getName(), (Throwable)e);
        }
        if (params == null) {
            params = new HashMap<String, Object>();
            beanContext.addBean(this.beanId, params, source);
        }
        params.put(parameter.getName(), parameter.getValue(executionContext.getContentDeliveryRuntime().getContentDeliveryConfig()));
    }

    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) throws SmooksException {
    }

    public void visitChildElement(Element childElement, ExecutionContext executionContext) throws SmooksException {
    }
}

